/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.composites;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IHistory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.ui.documents.Messages;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.LoggerFactory;

public class CategorySelectionEditComposite
extends Composite {
    private ComboViewer cbCategories;
    private IDocument document;

    public CategorySelectionEditComposite(Composite parent, int style, String storeId, boolean categoryCrudAllowed) {
        this(parent, style, new TransientOmnivoreDocument(storeId), categoryCrudAllowed);
    }

    public CategorySelectionEditComposite(Composite parent, int style, final IDocument document, boolean categoryCrudAllowed) {
        super(parent, style);
        ICategory cbSelection;
        this.document = document;
        this.setFocus();
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.cbCategories = new ComboViewer((Composite)this, 12);
        this.cbCategories.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cbCategories.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICategory) {
                    ICategory iCategory = (ICategory)element;
                    return iCategory.getName();
                }
                return super.getText(element);
            }
        });
        List categories = DocumentStoreServiceHolder.getService().getCategories(document);
        this.cbCategories.setInput((Object)categories);
        Button bNewCat = new Button((Composite)this, 8);
        bNewCat.setVisible(categoryCrudAllowed);
        bNewCat.setImage(Images.IMG_NEW.getImage());
        bNewCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(CategorySelectionEditComposite.this.getShell(), Messages.DocumentMetaDataDialog_newCategory, Messages.DocumentMetaDataDialog_newCategory, null, null);
                if (id.open() == 0) {
                    CategorySelectionEditComposite.this.addAndSelectCategory(id.getValue());
                }
            }
        });
        Button bEditCat = new Button((Composite)this, 8);
        bEditCat.setImage(Images.IMG_EDIT.getImage());
        bEditCat.setVisible(categoryCrudAllowed);
        bEditCat.setToolTipText(Messages.DocumentMetaDataDialog_renameCategory);
        bEditCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id;
                ISelection old = CategorySelectionEditComposite.this.cbCategories.getSelection();
                Object selection = ((StructuredSelection)old).getFirstElement();
                if (selection instanceof ICategory && (id = new InputDialog(CategorySelectionEditComposite.this.getShell(), MessageFormat.format(Messages.DocumentMetaDataDialog_renameCategoryConfirm, ((ICategory)selection).getName()), Messages.DocumentMetaDataDialog_renameCategoryText, ((ICategory)selection).getName(), null)).open() == 0) {
                    DocumentStoreServiceHolder.getService().renameCategory(document, id.getValue());
                    ((ICategory)selection).setName(id.getValue());
                    CategorySelectionEditComposite.this.cbCategories.refresh();
                }
            }
        });
        Button bDeleteCat = new Button((Composite)this, 8);
        bDeleteCat.setVisible(categoryCrudAllowed);
        bDeleteCat.setImage(Images.IMG_DELETE.getImage());
        bDeleteCat.setToolTipText(Messages.DocumentMetaDataDialog_deleteCategory);
        bDeleteCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ISelection old = CategorySelectionEditComposite.this.cbCategories.getSelection();
                Object selection = ((StructuredSelection)old).getFirstElement();
                InputDialog id = new InputDialog(CategorySelectionEditComposite.this.getShell(), MessageFormat.format(Messages.DocumentMetaDataDialog_deleteCategoryConfirm, ((ICategory)selection).getName()), Messages.DocumentMetaDataDialog_deleteCategoryText, "", null);
                if (id.open() == 0) {
                    try {
                        document.setCategory((ICategory)selection);
                        document.setCategory(DocumentStoreServiceHolder.getService().removeCategory(document, id.getValue()));
                        if (CategorySelectionEditComposite.this.findComboElementByName(document.getCategory().getName()) == null) {
                            CategorySelectionEditComposite.this.cbCategories.add((Object)document.getCategory());
                        }
                        CategorySelectionEditComposite.this.cbCategories.remove(selection);
                        CategorySelectionEditComposite.this.cbCategories.setSelection((ISelection)new StructuredSelection((Object)document.getCategory()), true);
                    }
                    catch (ElexisException e) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("existing document references", (Throwable)e);
                        SWTHelper.showError((String)Messages.DocumentMetaDataDialog_deleteCategoryError, (String)Messages.DocumentMetaDataDialog_deleteCategoryErrorText);
                    }
                }
            }
        });
        Object object = cbSelection = document.getCategory() != null ? document.getCategory() : this.cbCategories.getElementAt(0);
        if (cbSelection != null) {
            if (!categories.contains(cbSelection)) {
                String categoryName = cbSelection.getName();
                Optional<ICategory> matchingName = categories.stream().filter(cat -> cat.getName() != null && cat.getName().equals(categoryName)).findFirst();
                cbSelection = matchingName.isPresent() ? matchingName.get() : DocumentStoreServiceHolder.getService().getDefaultCategory(document);
            }
            this.cbCategories.setSelection((ISelection)new StructuredSelection((Object)cbSelection), true);
        }
    }

    public void setCategoryByName(String category) {
        ICategory _category = this.findComboElementByName(category);
        if (_category == null) {
            this.addAndSelectCategory(category);
        } else {
            this.cbCategories.setSelection((ISelection)new StructuredSelection((Object)_category), true);
        }
    }

    private ICategory findComboElementByName(String name) {
        List items = (List)this.cbCategories.getInput();
        if (items != null) {
            for (Object o : items) {
                if (!(o instanceof ICategory) || !((ICategory)o).getName().equals(name)) continue;
                return (ICategory)o;
            }
        }
        return null;
    }

    private void addAndSelectCategory(String categoryName) {
        this.document.setCategory(DocumentStoreServiceHolder.getService().createCategory(this.document, categoryName));
        if (!((List)this.cbCategories.getInput()).contains(this.document.getCategory())) {
            this.cbCategories.add((Object)this.document.getCategory());
        }
        this.cbCategories.setSelection((ISelection)new StructuredSelection((Object)this.document.getCategory()), true);
    }

    protected void checkSubclass() {
    }

    public void addSelectionChangeListener(ISelectionChangedListener listener) {
        this.cbCategories.addSelectionChangedListener(listener);
    }

    @Nullable
    public ICategory getSelection() {
        StructuredSelection comboSelection = (StructuredSelection)this.cbCategories.getSelection();
        if (comboSelection != null) {
            return (ICategory)comboSelection.getFirstElement();
        }
        return null;
    }

    private static class TransientOmnivoreDocument
    implements IDocument {
        private ICategory category;
        private String storeId;

        public TransientOmnivoreDocument(String storeId) {
            this.storeId = storeId;
        }

        public String getId() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public boolean addXid(String domain, String id, boolean updateIfExists) {
            return false;
        }

        public IXid getXid(String domain) {
            return null;
        }

        public Long getLastupdate() {
            return null;
        }

        public boolean isDeleted() {
            return false;
        }

        public void setDeleted(boolean value) {
        }

        public String getTitle() {
            return null;
        }

        public void setTitle(String value) {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String value) {
        }

        public List<DocumentStatus> getStatus() {
            return null;
        }

        public void setStatus(DocumentStatus status, boolean active) {
        }

        public Date getCreated() {
            return null;
        }

        public void setCreated(Date value) {
        }

        public Date getLastchanged() {
            return null;
        }

        public void setLastchanged(Date value) {
        }

        public String getMimeType() {
            return null;
        }

        public void setMimeType(String value) {
        }

        public ICategory getCategory() {
            return this.category;
        }

        public void setCategory(ICategory value) {
            this.category = value;
        }

        public List<IHistory> getHistory() {
            return null;
        }

        public String getStoreId() {
            return this.storeId;
        }

        public void setStoreId(String value) {
        }

        public String getExtension() {
            return null;
        }

        public void setExtension(String value) {
        }

        public String getKeywords() {
            return null;
        }

        public void setKeywords(String value) {
        }

        public IPatient getPatient() {
            return null;
        }

        public void setPatient(IPatient value) {
        }

        public IContact getAuthor() {
            return null;
        }

        public void setAuthor(IContact value) {
        }

        public InputStream getContent() {
            return null;
        }

        public void setContent(InputStream content) {
        }

        public long getContentLength() {
            return 0L;
        }
    }
}

