/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.model;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.EndingType;
import ch.elexis.core.model.agenda.SeriesType;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentSeries
implements IAppointmentSeries {
    private static Logger logger = LoggerFactory.getLogger(AppointmentSeries.class);
    private IAppointment appointment;
    private String groupId;
    private IAppointment rootAppointment;
    private SeriesType seriesType;
    private EndingType endingType;
    private String seriesPatternString;
    private String endingPatternString;
    private LocalDate endsOnDate;
    private LocalDate startDate;
    private LocalTime startTime;
    private LocalTime endTime;
    private boolean rootPresistent;
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HHmm");
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("ddMMyyyy");

    public AppointmentSeries(IAppointment appointment) {
        this.appointment = appointment;
        this.groupId = appointment.getLinkgroup();
        Optional foundRoot = CoreModelServiceHolder.get().load(this.groupId, IAppointment.class, true);
        this.rootPresistent = foundRoot.isPresent();
        this.rootAppointment = foundRoot.orElse(appointment);
        if (this.rootPresistent) {
            this.parseSerienTerminConfigurationString(this.rootAppointment.getExtension());
        }
    }

    private void parseSerienTerminConfigurationString(String serienTerminConfigurationString) {
        String[] terms = serienTerminConfigurationString.split(";");
        String[] termin = terms[0].split(",");
        try {
            this.startTime = LocalTime.parse(termin[0], this.timeFormatter);
            this.endTime = LocalTime.parse(termin[1], this.timeFormatter);
            this.startDate = LocalDate.parse(terms[3], this.dateFormatter);
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
        }
        char seriesTypeCharacter = terms[1].toUpperCase().charAt(0);
        this.setSeriesType(SeriesType.getForCharacter((char)seriesTypeCharacter));
        this.seriesPatternString = terms[2];
        char endingTypeCharacter = terms[4].toUpperCase().charAt(0);
        this.endingType = EndingType.getForCharacter((char)endingTypeCharacter);
        this.endingPatternString = terms[5];
        switch (this.endingType) {
            case ON_SPECIFIC_DATE: {
                try {
                    this.endsOnDate = LocalDate.parse(this.endingPatternString, this.dateFormatter);
                }
                catch (Exception e) {
                    logger.error("unexpected exception", (Throwable)e);
                }
                break;
            }
        }
    }

    public String getReason() {
        return this.appointment.getReason();
    }

    public void setReason(String value) {
        this.appointment.setReason(value);
    }

    public String getState() {
        return this.appointment.getState();
    }

    public void setState(String value) {
        this.appointment.setState(value);
    }

    public String getType() {
        return this.appointment.getType();
    }

    public void setType(String value) {
        this.appointment.setType(value);
    }

    public Integer getDurationMinutes() {
        return this.appointment.getDurationMinutes();
    }

    public String getSchedule() {
        return this.appointment.getSchedule();
    }

    public void setSchedule(String value) {
        this.appointment.setSchedule(value);
    }

    public String getCreatedBy() {
        return this.appointment.getCreatedBy();
    }

    public void setCreatedBy(String value) {
        this.appointment.setCreatedBy(value);
    }

    public String getSubjectOrPatient() {
        return this.appointment.getSubjectOrPatient();
    }

    public void setSubjectOrPatient(String value) {
        this.appointment.setSubjectOrPatient(value);
    }

    public int getPriority() {
        return this.appointment.getPriority();
    }

    public void setPriority(int value) {
        this.appointment.setPriority(value);
    }

    public int getTreatmentReason() {
        return this.appointment.getTreatmentReason();
    }

    public void setTreatmentReason(int value) {
        this.appointment.setTreatmentReason(value);
    }

    public int getInsuranceType() {
        return this.appointment.getInsuranceType();
    }

    public void setInsuranceType(int value) {
        this.appointment.setInsuranceType(value);
    }

    public int getCaseType() {
        return this.appointment.getCaseType();
    }

    public void setCaseType(int value) {
        this.appointment.setCaseType(value);
    }

    public String getLinkgroup() {
        return this.groupId;
    }

    public void setLinkgroup(String value) {
        this.appointment.setLinkgroup(value);
    }

    public String getExtension() {
        return this.appointment.getExtension();
    }

    public void setExtension(String value) {
        this.appointment.setExtension(value);
    }

    public String getCreated() {
        return this.appointment.getCreated();
    }

    public void setCreated(String value) {
        this.appointment.setCreated(value);
    }

    public String getLastEdit() {
        return this.appointment.getLastEdit();
    }

    public void setLastEdit(String value) {
        this.appointment.setLastEdit(value);
    }

    public String getStateHistory() {
        return this.appointment.getStateHistory();
    }

    public void setStateHistory(String value) {
        this.appointment.setStateHistory(value);
    }

    public boolean isRecurring() {
        return this.appointment.isRecurring();
    }

    public IContact getContact() {
        return this.appointment.getContact();
    }

    public String getStateHistoryFormatted(String formatPattern) {
        return this.appointment.getStateHistoryFormatted(formatPattern);
    }

    public LocalDateTime getStartTime() {
        return this.appointment.getStartTime();
    }

    public void setStartTime(LocalDateTime value) {
    }

    public LocalDateTime getEndTime() {
        return this.appointment.getEndTime();
    }

    public void setEndTime(LocalDateTime value) {
    }

    public String getId() {
        return this.appointment.getId();
    }

    public String getLabel() {
        return this.appointment.getLabel();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this.appointment, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this.appointment, domain);
    }

    public Long getLastupdate() {
        return this.appointment.getLastupdate();
    }

    public boolean isDeleted() {
        return this.appointment.isDeleted();
    }

    public void setDeleted(boolean value) {
        this.appointment.setDeleted(value);
    }

    public SeriesType getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(SeriesType value) {
        this.seriesType = value;
    }

    public EndingType getEndingType() {
        return this.endingType;
    }

    public void setEndingType(EndingType value) {
        this.endingType = value;
    }

    public LocalDate getSeriesStartDate() {
        return this.startDate;
    }

    public void setSeriesStartDate(LocalDate value) {
        this.startDate = value;
    }

    public LocalDate getSeriesEndDate() {
        return this.endsOnDate;
    }

    public void setSeriesEndDate(LocalDate value) {
        this.endsOnDate = value;
    }

    public String getSeriesPatternString() {
        return this.seriesPatternString;
    }

    public void setSeriesPatternString(String value) {
        this.seriesPatternString = value;
    }

    public String getEndingPatternString() {
        return this.endingPatternString;
    }

    public void setEndingPatternString(String value) {
        this.endingPatternString = value;
    }

    public LocalTime getSeriesStartTime() {
        return this.startTime;
    }

    public void setSeriesStartTime(LocalTime value) {
        this.startTime = value;
    }

    public LocalTime getSeriesEndTime() {
        return this.endTime;
    }

    public void setSeriesEndTime(LocalTime value) {
        this.endTime = value;
    }

    public boolean isPersistent() {
        return this.rootPresistent;
    }

    public IAppointment getRootAppointment() {
        return this.rootAppointment;
    }

    public String getAsSeriesExtension() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.timeFormatter.format(this.startTime));
            sb.append(",");
            sb.append(this.timeFormatter.format(this.endTime));
            sb.append(";");
            sb.append(this.getSeriesType().getSeriesTypeCharacter());
            sb.append(";");
            sb.append(this.seriesPatternString);
            sb.append(";");
            sb.append(this.dateFormatter.format(this.startDate));
            sb.append(";");
            sb.append(this.endingType.getEndingTypeChar());
            sb.append(";");
            switch (this.getEndingType()) {
                case AFTER_N_OCCURENCES: {
                    sb.append(this.endingPatternString);
                    break;
                }
                case ON_SPECIFIC_DATE: {
                    sb.append(this.dateFormatter.format(this.endsOnDate));
                    break;
                }
            }
        }
        catch (NullPointerException npe) {
            sb.append("incomplete configuration string: " + npe.getMessage());
        }
        return sb.toString();
    }
}

