/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.services.IVirtualFilesystemService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jcifs.SmbResource;
import jcifs.SmbTreeHandle;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.URIUtil;
import org.slf4j.LoggerFactory;

public class VirtualFilesystemHandle
implements IVirtualFilesystemService.IVirtualFilesystemHandle {
    private static final String ERROR_MESSAGE_CAN_NOT_HANDLE = "Can not handle type";
    private final URI uri;

    public VirtualFilesystemHandle(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public VirtualFilesystemHandle(File file) throws IOException {
        this(file.toURI());
    }

    public InputStream openInputStream() throws IOException {
        File file = URIUtil.toFile((URI)this.uri);
        if (file != null) {
            return new FileInputStream(file);
        }
        URL url = URIUtil.toURL((URI)this.uri);
        return url.openStream();
    }

    /*
     * Loose catch block
     */
    public byte[] readAllBytes() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream byteArrayOutputStream;
            InputStream in;
            block16: {
                block15: {
                    in = this.openInputStream();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                    if (byteArrayOutputStream == null) break block15;
                    byteArrayOutputStream.close();
                }
                if (in == null) break block16;
                in.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public long getContentLenght() throws IOException {
        File file = URIUtil.toFile((URI)this.uri);
        if (file != null) {
            return file.length();
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (SmbFile smbFile = (SmbFile)connection;){
                return smbFile.getContentLengthLong();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IOException("Can not determine content length on [" + connection.getClass() + "]");
    }

    public OutputStream openOutputStream() throws IOException {
        if (!this.isDirectory()) {
            File file = URIUtil.toFile((URI)this.uri);
            if (file != null) {
                return new FileOutputStream(file);
            }
            URLConnection openConnection = this.uri.toURL().openConnection();
            if (openConnection != null) {
                return openConnection.getOutputStream();
            }
        }
        throw new IOException("Does not support outputstream on directory");
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle copyTo(IVirtualFilesystemService.IVirtualFilesystemHandle target) throws IOException {
        if (target.isDirectory()) {
            String targetString = this.getName().replace(" ", "%20");
            URI targetURI = target.getURI().resolve(targetString);
            target = new VirtualFilesystemHandle(targetURI);
            return this.copyTo(target);
        }
        Throwable throwable = null;
        Object var3_6 = null;
        try (InputStream in = this.openInputStream();){
            Throwable throwable2 = null;
            Object var6_11 = null;
            try (OutputStream out = target.openOutputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return target;
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle getParent() throws IOException {
        File file = URIUtil.toFile((URI)this.uri);
        if (file != null) {
            URI parent = file.getParentFile().toURI();
            return new VirtualFilesystemHandle(parent);
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (SmbFile smbFile = (SmbFile)connection;){
                URL parent = new URL(smbFile.getParent());
                return new VirtualFilesystemHandle(parent.toURI());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IOException(ERROR_MESSAGE_CAN_NOT_HANDLE);
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles() throws IOException {
        return this.listHandles(null);
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles(IVirtualFilesystemService.IVirtualFilesystemhandleFilter ff) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException("not a directory [" + this.uri + "]");
        }
        Optional<File> file = this.toFile();
        if (file.isPresent()) {
            File[] listFiles = file.get().listFiles(new IVFSFileFilterAdapter(ff));
            IVirtualFilesystemService.IVirtualFilesystemHandle[] retVal = new IVirtualFilesystemService.IVirtualFilesystemHandle[listFiles.length];
            int i = 0;
            while (i < listFiles.length) {
                File _file = listFiles[i];
                retVal[i] = new VirtualFilesystemHandle(_file);
                ++i;
            }
            return retVal;
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            Throwable throwable = null;
            Object var5_9 = null;
            try (SmbFile smbFile = (SmbFile)connection;){
                SmbFile[] listFiles = smbFile.listFiles((SmbFileFilter)new IVFSFileFilterAdapter(ff));
                IVirtualFilesystemService.IVirtualFilesystemHandle[] retVal = new IVirtualFilesystemService.IVirtualFilesystemHandle[listFiles.length];
                int i = 0;
                while (i < listFiles.length) {
                    try {
                        Throwable throwable2 = null;
                        Object var11_19 = null;
                        try (SmbFile _file = listFiles[i];){
                            String fileURL = this.convertToURLEscapingIllegalCharacters(_file.getURL());
                            URI _fileUri = new URI(fileURL);
                            retVal[i] = new VirtualFilesystemHandle(_fileUri);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (URISyntaxException e) {
                        LoggerFactory.getLogger(this.getClass()).warn("listHandles() [{}]", (Object)listFiles[i], (Object)e);
                    }
                    ++i;
                }
                return retVal;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        throw new IOException(ERROR_MESSAGE_CAN_NOT_HANDLE);
    }

    public void delete() throws IOException {
        if (this.toFile().isPresent()) {
            File file = this.toFile().get();
            if (file.isDirectory()) {
                List<IVirtualFilesystemService.IVirtualFilesystemHandle> subHandles = Arrays.asList(this.listHandles());
                for (IVirtualFilesystemService.IVirtualFilesystemHandle subHandle : subHandles) {
                    subHandle.delete();
                }
            }
            Files.delete(this.toFile().get().toPath());
            return;
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            Throwable throwable = null;
            Object var3_9 = null;
            try (SmbFile smbFile = (SmbFile)connection;){
                smbFile.delete();
                return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IOException(ERROR_MESSAGE_CAN_NOT_HANDLE);
    }

    public URL toURL() {
        try {
            return URIUtil.toURL((URI)this.uri);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(this.getClass()).warn("toURL()", (Throwable)e);
            return null;
        }
    }

    public boolean isDirectory() throws IOException {
        if (this.toFile().isPresent()) {
            File file = this.toFile().get();
            return file.isDirectory();
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (SmbFile smbFile = (SmbFile)connection;){
                    return smbFile.isDirectory();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SmbException e) {
                throw new IOException(e);
            }
        }
        throw new IOException(ERROR_MESSAGE_CAN_NOT_HANDLE);
    }

    public Optional<File> toFile() {
        return Optional.ofNullable(URIUtil.toFile((URI)this.uri));
    }

    private Optional<SmbFile> toSmbFile() {
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            if (connection instanceof SmbFile) {
                Throwable throwable = null;
                Object var3_5 = null;
                try (SmbFile smbFile = (SmbFile)connection;){
                    return Optional.of(smbFile);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("toSmbFile()", (Throwable)e);
        }
        return Optional.empty();
    }

    public String getExtension() {
        String _url = this.uri.toString();
        int lastIndexOf = _url.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return _url.substring(lastIndexOf + 1);
        }
        return "";
    }

    public boolean exists() throws IOException {
        File file = URIUtil.toFile((URI)this.uri);
        if (file != null) {
            return file.exists();
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (SmbFile smbFile = (SmbFile)connection;){
                return smbFile.exists();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IOException(ERROR_MESSAGE_CAN_NOT_HANDLE);
    }

    public String getName() {
        String path = this.uri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return FilenameUtils.getName((String)path);
    }

    public boolean canRead() {
        Optional<File> file = this.toFile();
        if (file.isPresent()) {
            return file.get().canRead();
        }
        Optional<SmbFile> smbFile = this.toSmbFile();
        if (smbFile.isPresent()) {
            try {
                return smbFile.get().canRead();
            }
            catch (SmbException smbException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean canWrite() {
        Optional<File> file = this.toFile();
        if (file.isPresent()) {
            return file.get().canWrite();
        }
        Optional<SmbFile> smbFile = this.toSmbFile();
        if (smbFile.isPresent()) {
            try {
                return smbFile.get().canWrite();
            }
            catch (SmbException smbException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getAbsolutePath() {
        return this.uri.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IVirtualFilesystemService.IVirtualFilesystemHandle moveTo(IVirtualFilesystemService.IVirtualFilesystemHandle target) throws IOException {
        Optional _target;
        if (target.isDirectory()) {
            String targetString = this.getName().replace(" ", "%20");
            URI targetURI = target.getURI().resolve(targetString);
            target = new VirtualFilesystemHandle(targetURI);
            return this.moveTo(target);
        }
        Optional<File> file = this.toFile();
        if (file.isPresent() && (_target = target.toFile()).isPresent()) {
            Path path = Files.move(file.get().toPath(), ((File)_target.get()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            return new VirtualFilesystemHandle(path.toFile());
        }
        Optional<SmbFile> smbFile = this.toSmbFile();
        if (!smbFile.isPresent()) throw new IOException("Invalid type");
        Optional<SmbFile> smbFileTarget = ((VirtualFilesystemHandle)target).toSmbFile();
        if (!smbFileTarget.isPresent()) return target;
        Throwable throwable = null;
        Object var6_10 = null;
        try {
            SmbTreeHandle smbFileTh = smbFile.get().getTreeHandle();
            try {
                try (SmbTreeHandle smbFileThTarget = smbFileTarget.get().getTreeHandle();){
                    if (smbFileTh.isSameTree(smbFileThTarget)) {
                        smbFile.get().renameTo((SmbResource)smbFileTarget.get());
                    } else {
                        smbFile.get().copyTo((SmbResource)smbFileTarget.get());
                        smbFile.get().delete();
                    }
                }
                if (smbFileTh == null) return target;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (smbFileTh == null) throw throwable;
                smbFileTh.close();
                throw throwable;
            }
            smbFileTh.close();
            return target;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle subDir(String subDir) throws IOException {
        if (!subDir.endsWith("/")) {
            subDir = String.valueOf(subDir) + "/";
        }
        URI _uri = null;
        if (this.uri.getAuthority() != null && this.uri.getAuthority().length() > 0 && this.uri.getAuthority().charAt(1) == ':') {
            String _cur = this.uri.toString();
            if (!_cur.endsWith("/")) {
                _cur = String.valueOf(_cur) + "/";
            }
            try {
                _uri = IVirtualFilesystemService.stringToURI((String)(String.valueOf(_cur) + subDir));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IOException(e);
            }
        } else {
            _uri = URIUtil.append((URI)this.uri, (String)subDir);
        }
        return new VirtualFilesystemHandle(_uri);
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle subFile(String subFile) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException("[" + this.uri + "] is not a directory");
        }
        if (subFile.startsWith("/")) {
            throw new IllegalArgumentException("must not start with /");
        }
        URI _uri = null;
        if (this.uri.getAuthority() != null && this.uri.getAuthority().length() > 0 && this.uri.getAuthority().charAt(1) == ':') {
            try {
                _uri = IVirtualFilesystemService.stringToURI((String)(String.valueOf(this.uri.toString()) + subFile));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IOException(e);
            }
        } else {
            _uri = URIUtil.append((URI)this.uri, (String)subFile);
        }
        return new VirtualFilesystemHandle(_uri);
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle mkdir() throws IOException {
        File file = URIUtil.toFile((URI)this.uri);
        if (file != null) {
            file.mkdir();
            return this;
        }
        URLConnection connection = this.uri.toURL().openConnection();
        if (connection instanceof SmbFile) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (SmbFile smbFile = (SmbFile)connection;){
                if (!smbFile.exists()) {
                    smbFile.mkdir();
                }
                return this;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IOException(ERROR_MESSAGE_CAN_NOT_HANDLE);
    }

    public URI getURI() {
        return this.uri;
    }

    private String convertToURLEscapingIllegalCharacters(URL url) throws MalformedURLException, URISyntaxException {
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        return uri.toString().replace("%25", "%");
    }

    private class IVFSFileFilterAdapter
    implements FileFilter,
    SmbFileFilter {
        private final IVirtualFilesystemService.IVirtualFilesystemhandleFilter ff;

        public IVFSFileFilterAdapter(IVirtualFilesystemService.IVirtualFilesystemhandleFilter ff) {
            this.ff = ff;
        }

        @Override
        public boolean accept(File pathname) {
            if (this.ff == null) {
                return true;
            }
            try {
                VirtualFilesystemHandle pathnameVfsHandle = new VirtualFilesystemHandle(pathname);
                return this.ff.accept((IVirtualFilesystemService.IVirtualFilesystemHandle)pathnameVfsHandle);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("accept()", (Throwable)e);
                return false;
            }
        }

        public boolean accept(SmbFile file) throws SmbException {
            if (this.ff == null) {
                return true;
            }
            try {
                String fileURL = VirtualFilesystemHandle.this.convertToURLEscapingIllegalCharacters(file.getURL());
                URI fileUri = new URI(fileURL);
                VirtualFilesystemHandle pathnameVfsHandle = new VirtualFilesystemHandle(fileUri);
                return this.ff.accept((IVirtualFilesystemService.IVirtualFilesystemHandle)pathnameVfsHandle);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

