/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.XidQuality;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.services.XidDomain;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.internal.TransientXid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class XidService
implements IXidService {
    private static Logger logger = LoggerFactory.getLogger(XidService.class);
    private HashMap<String, XidDomain> domains;
    private HashMap<String, String> domainMap;
    @Reference
    private IConfigService configService;

    @Activate
    private void activate() {
        this.domains = new HashMap();
        this.domainMap = new HashMap();
        this.loadDomains();
    }

    public IXidService.IXidDomain getDomain(String name) {
        String dom = this.domainMap.get(name);
        if (dom != null) {
            name = dom;
        }
        return this.domains.get(name);
    }

    public List<IXidService.IXidDomain> getDomains() {
        return new ArrayList<IXidService.IXidDomain>(this.domains.values());
    }

    private void loadDomains() {
        String storedDomains = this.configService.get("LocalXIDDomains", null);
        if (storedDomains == null) {
            this.domains.put("www.elexis.ch/xid", new XidDomain("www.elexis.ch/xid", "UUID", 5, "ch.elexis.data.PersistentObject"));
            this.domains.put("www.ahv.ch/xid", new XidDomain("www.ahv.ch/xid", "AHV", 2, "ch.elexis.data.Person"));
            this.domains.put("www.xid.ch/id/oid", new XidDomain("www.xid.ch/id/oid", "OID", 7, "ch.elexis.data.PersistentObject"));
            this.domains.put("www.xid.ch/id/ean", new XidDomain("www.xid.ch/id/ean", "EAN", 2, "ch.elexis.data.Kontakt,ch.elexis.data.Person,ch.elexis.data.Organisation"));
            this.storeDomains();
        } else {
            String[] stringArray = storedDomains.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String domainString = stringArray[n2];
                String[] spl = domainString.split("#");
                if (spl.length < 2) {
                    logger.error("Fehler in XID-Domain " + domainString);
                }
                String simpleName = "";
                if (spl.length >= 3) {
                    simpleName = spl[2];
                }
                String displayOptions = "Kontakt";
                if (spl.length >= 4) {
                    displayOptions = spl[3];
                }
                this.domains.put(spl[0], new XidDomain(spl[0], simpleName, Integer.parseInt(spl[1]), displayOptions));
                this.domainMap.put(simpleName, spl[0]);
                ++n2;
            }
        }
    }

    private void storeDomains() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.domains.keySet()) {
            XidDomain xd = this.domains.get(k);
            sb.append(k).append("#").append(xd.getQuality()).append("#").append(xd.getSimpleName()).append("#").append(xd.getDisplayOptions()).append(";");
        }
        this.configService.set("LocalXIDDomains", sb.toString());
    }

    public IXidService.IXidDomain localRegisterXIDDomain(String domainName, String simpleName, int quality) {
        if (this.domains.containsKey(domainName)) {
            logger.error("XID Domain " + domainName + " bereits registriert");
        } else if (domainName.matches(".*[;#].*")) {
            logger.error("XID Domain " + domainName + " ung\u00fcltig");
        } else {
            XidDomain created = new XidDomain(domainName, simpleName == null ? "" : simpleName, quality, "Kontakt");
            this.domains.put(domainName, created);
            if (simpleName != null) {
                this.domainMap.put(simpleName, domainName);
            }
            this.storeDomains();
            return created;
        }
        return null;
    }

    public IXidService.IXidDomain localRegisterXIDDomainIfNotExists(String domainName, String simpleName, int quality) {
        XidDomain existing = this.domains.get(domainName);
        if (existing == null) {
            return this.localRegisterXIDDomain(domainName, simpleName, quality);
        }
        return existing;
    }

    public <T> Optional<T> findObject(String domainName, String domainId, Class<T> clazz) {
        String dom = this.domainMap.get(domainName);
        if (dom != null) {
            domainName = dom;
        }
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IXid.class, new String[]{"domain", "domainid"});
        List xids = query.executeWithParameters(query.getParameterMap(new Object[]{"domain", domainName, "domainid", domainId}));
        List ret = xids.parallelStream().map(iXid -> iXid.getObject(clazz)).filter(Objects::nonNull).collect(Collectors.toList());
        if (ret.size() == 1) {
            return Optional.of(ret.get(0));
        }
        if (ret.size() > 1) {
            throw new IllegalStateException("Found more than one object for [" + domainName + "] [" + domainId + "]");
        }
        return Optional.empty();
    }

    public String getDomainName(String domainName) {
        String dom = this.domainMap.get(domainName);
        if (dom != null) {
            return dom;
        }
        return domainName;
    }

    public boolean addXid(Identifiable identifiable, String domain, String id, boolean updateIfExists) {
        IXid existing = this.getXid(identifiable, domain = this.getDomainName(domain));
        if (existing != null) {
            if (updateIfExists) {
                IXid xid = existing;
                xid.setDomain(domain);
                xid.setDomainId(id);
                xid.setObject((Object)identifiable);
                CoreModelServiceHolder.get().save((Identifiable)xid);
                return true;
            }
        } else {
            IXid xid = (IXid)CoreModelServiceHolder.get().create(IXid.class);
            xid.setDomain(domain);
            xid.setDomainId(id);
            xid.setObject((Object)identifiable);
            CoreModelServiceHolder.get().save((Identifiable)xid);
            return true;
        }
        return false;
    }

    public IXid getXid(Identifiable identifiable, String domain) {
        if ("www.elexis.ch/xid".equals(domain)) {
            return new TransientXid("www.elexis.ch/xid", identifiable.getId(), XidQuality.ASSIGNMENT_LOCAL_QUALITY_GUID, identifiable);
        }
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IXid.class, new String[]{"domain", "objectid"});
        List xids = query.executeWithParameters(query.getParameterMap(new Object[]{"domain", domain, "objectid", identifiable.getId()}));
        if (xids.size() > 0) {
            if (xids.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).error("XID [" + domain + "] [" + identifiable.getId() + "] on multiple objects, returning first.");
            }
            return (IXid)xids.get(0);
        }
        return null;
    }

    public List<IXid> getXids(Identifiable identifiable) {
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IXid.class, new String[]{"objectid"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"objectid", identifiable.getId()}));
    }
}

