/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.console;

import ch.elexis.core.console.AbstractConsoleCommandProvider;
import ch.elexis.core.console.CmdAdvisor;
import ch.elexis.core.console.CmdParam;
import ch.elexis.core.console.ConsoleProgressMonitor;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.internal.model.service.CoreModelServiceHolder;
import ch.elexis.core.tasks.internal.service.TaskDescriptor;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.tasks.model.OwnerTaskNotification;
import ch.elexis.core.tasks.model.TaskTriggerType;
import ch.elexis.core.time.TimeUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommandProvider.class}, immediate=true)
public class ConsoleCommandProvider
extends AbstractConsoleCommandProvider {
    @Reference
    private ITaskService taskService;
    @Reference(target="(service.model.name=ch.elexis.core.tasks.model)")
    private IModelService taskModelService;
    @Reference
    private IContextService contextService;
    @Reference
    private IVirtualFilesystemService vfsService;

    @Activate
    public void activate() {
        this.register(((Object)((Object)this)).getClass());
    }

    @CmdAdvisor(description="task management")
    public void _task(CommandInterpreter ci) {
        this.executeCommand("task", ci);
    }

    @CmdAdvisor(description="show last executed tasks")
    public void __task_last(@CmdParam(required=false, description="max: default=20") String maxEntries, @CmdParam(required=false, description="tdIdOrRefId") String tdIdOrRefId) {
        IQuery query = this.taskModelService.getQuery(ITask.class);
        if (maxEntries != null) {
            query.limit(Integer.valueOf(maxEntries).intValue());
        } else {
            query.limit(20);
        }
        if (tdIdOrRefId != null) {
            ITaskDescriptor taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(tdIdOrRefId).orElse(null);
            if (taskDescriptor == null) {
                this.fail("Unknown descriptorId or descriptorReferenceId");
                return;
            }
            query.and((EStructuralFeature)ModelPackage.Literals.ITASK__TASK_DESCRIPTOR, IQuery.COMPARATOR.EQUALS, (Object)taskDescriptor);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.ITASK__FINISHED_AT, IQuery.ORDER.DESC);
        List finishedTasks = query.execute();
        this.prflp("State", 8);
        this.prflp("Descriptor Id/RefId", 27);
        this.prflp("ID", 27);
        this.prflp("FinishTime", 25);
        this.prflp("CreateTime", 25);
        this.ci.print((Object)"Result\n");
        finishedTasks.stream().forEach(t -> {
            this.prflp(t.getState().name(), 8);
            this.prflp(t.getTaskDescriptor().getReferenceId(), 27);
            this.prflp(t.getId(), 27);
            this.prflp(TimeUtil.formatSafe((LocalDateTime)t.getFinishedAt()), 25);
            this.prflp(TimeUtil.formatSafe((LocalDateTime)t.getCreatedAt()), 25);
            this.ci.print((Object)(t.getResult() + "\n"));
        });
    }

    @CmdAdvisor(description="list tasks and current state")
    public void __task_list(@CmdParam(required=false, description="boolean: show system tasks") String showSystemTasks) {
        List<ITask> runningTasks = this.taskService.getRunningTasks();
        this.prflp("State", 8);
        this.prflp("Trigger", 11);
        this.prflp("ID", 27);
        this.prflp("Descriptor Id/RefId", 27);
        this.prflp("StartTime", 25);
        this.prflp("Owner / Runner / Runnable", 70, true);
        runningTasks.stream().forEach(t -> {
            ITaskDescriptor td = t.getTaskDescriptor();
            this.prflp("RUN", 8);
            this.prflp(td.getTriggerType().getName(), 11);
            this.prflp(t.getId(), 27);
            this.prflp(td.getReferenceId(), 27);
            this.prflp(TimeUtil.formatSafe((LocalDateTime)t.getRunAt()), 25);
            String owner = td.getOwner() != null ? td.getOwner().getId() : "null";
            this.prflp(String.valueOf(owner) + " / " + this.formatRunner(td.getRunner()) + " / " + td.getIdentifiedRunnableId(), 70, true);
        });
        List<ITaskDescriptor> incurredTasks = this.taskService.getIncurredTasks();
        incurredTasks.stream().forEach(td -> {
            this.prflp("INC", 8);
            this.prflp(td.getTriggerType().getName(), 11);
            this.prflp("", 27);
            this.prflp(td.getReferenceId(), 27);
            this.prflp("NR " + (String)td.getTransientData().get("cron-next-exectime"), 25);
            String owner = td.getOwner() != null ? td.getOwner().getId() : "null";
            this.prflp(String.valueOf(owner) + " / " + this.formatRunner(td.getRunner()) + " / " + td.getIdentifiedRunnableId(), 70, true);
        });
        IQuery tdQuery = this.taskModelService.getQuery(ITaskDescriptor.class, true, false);
        if (!"true".equalsIgnoreCase(showSystemTasks)) {
            tdQuery.and((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)false);
        }
        tdQuery.orderBy((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__ACTIVE, IQuery.ORDER.DESC);
        tdQuery.orderBy((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__RUNNER, IQuery.ORDER.DESC);
        List taskDescriptors = tdQuery.execute();
        taskDescriptors.removeAll(incurredTasks);
        taskDescriptors.stream().forEach(td -> {
            String state = td.isActive() ? "ACT" : "INACT";
            this.prflp(state, 8);
            this.prflp(td.getTriggerType().getName(), 11);
            this.prflp("", 27);
            this.prflp(String.valueOf(td.isSystem() ? "S-" : "") + td.getReferenceId(), 27);
            this.prflp("", 25);
            String owner = td.getOwner() != null ? td.getOwner().getId() : "null";
            this.prflp(String.valueOf(owner) + " / " + this.formatRunner(td.getRunner()) + " / " + td.getIdentifiedRunnableId(), 70, true);
        });
    }

    private String formatRunner(String runner) {
        if (this.contextService.getStationIdentifier().equalsIgnoreCase(runner)) {
            return runner.toUpperCase();
        }
        return runner.toLowerCase();
    }

    @CmdAdvisor(description="Activate a task descriptor for execution")
    public String __task_activate(@CmdParam(description="taskId | tdIdOrTdRefId") String idOrReferenceId) throws TaskException {
        Optional<ITaskDescriptor> taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(idOrReferenceId);
        if (!taskDescriptor.isPresent()) {
            return "Invalid or ambiguous id argument";
        }
        this.taskService.setActive(taskDescriptor.get(), true);
        return this.ok();
    }

    @CmdAdvisor(description="Deactivate a task descriptor for execution")
    public String __task_deactivate(@CmdParam(description="taskId | tdIdOrTdRefId") String idOrReferenceId) throws TaskException {
        Optional<ITaskDescriptor> taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(idOrReferenceId);
        if (!taskDescriptor.isPresent()) {
            return "Invalid or ambiguous id argument";
        }
        this.taskService.setActive(taskDescriptor.get(), false);
        return this.ok();
    }

    @CmdAdvisor(description="Gracefully cancel a running task")
    public void __task_cancel(@CmdParam(description="taskId | tdIdOrTdRefId") String id) {
        List<ITask> activeTasks = this.taskService.getRunningTasks();
        for (ITask task : activeTasks) {
            if (!id.equals(task.getId()) && !id.equals(task.getTaskDescriptor().getId()) && !id.equalsIgnoreCase(task.getTaskDescriptor().getReferenceId())) continue;
            task.getProgressMonitor().setCanceled(true);
            this.ok("Sent setCanceled to Task " + task.getId());
            return;
        }
        this.fail("No matching task for given id");
    }

    @CmdAdvisor(description="create or modify a task descriptor from a json file")
    public void __task_descriptor_url(@CmdParam(description="url") String urlString) throws IOException, TaskException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        IVirtualFilesystemService.IVirtualFilesystemHandle of = this.vfsService.of(urlString);
        String content = new String(of.readAllBytes(), StandardCharsets.UTF_8);
        TaskDescriptor fromJson = (TaskDescriptor)gson.fromJson(content, TaskDescriptor.class);
        this.taskService.saveTaskDescriptor(fromJson);
    }

    @CmdAdvisor(description="serialize a task descriptor to a json string")
    public void __task_descriptor_json(@CmdParam(description="tdIdOrTdRefId") String idOrReferenceId) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Optional<ITaskDescriptor> taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(idOrReferenceId);
        if (taskDescriptor.isPresent()) {
            ITaskDescriptor iTaskDescriptor = taskDescriptor.get();
            String json = gson.toJson((Object)iTaskDescriptor, TaskDescriptor.class);
            this.ci.println((Object)json);
        } else {
            this.fail("taskDescriptor not found");
        }
    }

    @CmdAdvisor(description="set attributes on a task descriptor")
    public String __task_descriptor_set(@CmdParam(description="tdIdOrTdRefId") String idOrReferenceId, @CmdParam(description="(owner | runner | referenceid | trigger | otn)") String key, @CmdParam(description="value ") String value) {
        ITaskDescriptor taskDescriptor;
        block24: {
            block22: {
                taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(idOrReferenceId).orElse(null);
                if (taskDescriptor == null) break block22;
                switch (key.toLowerCase()) {
                    case "owner": {
                        IUser user = CoreModelServiceHolder.get().load(value, IUser.class).orElse(null);
                        if (user != null) {
                            taskDescriptor.setOwner(user);
                            break;
                        }
                        return "userId not found";
                    }
                    case "runner": {
                        taskDescriptor.setRunner(value);
                        break;
                    }
                    case "referenceid": {
                        taskDescriptor.setReferenceId(value);
                        break;
                    }
                    case "trigger": {
                        TaskTriggerType ttt = TaskTriggerType.getByName(value.toUpperCase());
                        if (ttt != null) {
                            taskDescriptor.setTriggerType(ttt);
                            break;
                        }
                        return "TaskTriggerType not found";
                    }
                    case "otn": {
                        OwnerTaskNotification otn = OwnerTaskNotification.getByName(value.toUpperCase());
                        if (otn != null) {
                            taskDescriptor.setOwnerNotification(otn);
                            break;
                        }
                        return "OwnerTaskNotification not found";
                    }
                    default: {
                        if (!key.toLowerCase().startsWith("runcontext.")) break;
                        String keyVal = key.substring("runContext.".length());
                        taskDescriptor.setRunContextParameter(keyVal, (Serializable)((Object)value));
                    }
                }
                break block24;
            }
            return "taskDescriptor not found";
        }
        this.taskModelService.save((Identifiable)taskDescriptor);
        return this.ok();
    }

    @CmdAdvisor(description="manually trigger execution of a task descriptor")
    public void __task_trigger(@CmdParam(description="tdIdOrTdRefId") String idOrReferenceId) throws TaskException {
        Optional<ITaskDescriptor> taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(idOrReferenceId);
        if (taskDescriptor.isPresent()) {
            String result = this.taskService.trigger(taskDescriptor.get(), (IProgressMonitor)new ConsoleProgressMonitor(), TaskTriggerType.MANUAL, null).toString();
            this.ok(result);
        } else {
            this.fail("Invalid or ambiguous id argument");
        }
    }

    @CmdAdvisor(description="directly execute a runnable using its default context")
    public void __task_singleshot(@CmdParam(description="runnableId") String runnableId) throws TaskException {
        IIdentifiedRunnable runnable = this.taskService.instantiateRunnableById(runnableId);
        ITaskDescriptor taskDescriptor = this.taskService.createTaskDescriptor(runnable);
        String referenceId = taskDescriptor.getReferenceId();
        taskDescriptor.setReferenceId("sshot_" + referenceId);
        ITask task = this.taskService.triggerSync(taskDescriptor, (IProgressMonitor)new ConsoleProgressMonitor(), TaskTriggerType.MANUAL, null);
        Map<String, ?> result = task.getResult();
        Set<String> keySet = result.keySet();
        for (String key : keySet) {
            this.ci.println((Object)(String.valueOf(key) + ":" + result.get(key)));
        }
        this.taskModelService.delete((Deleteable)taskDescriptor);
    }

    @CmdAdvisor(description="deactivate and remove a task descriptor")
    public void __task_descriptor_remove(@CmdParam(description="tdIdOrTdRefId") String idOrReferenceId) throws TaskException {
        Optional<ITaskDescriptor> taskDescriptor = this.taskService.findTaskDescriptorByIdOrReferenceId(idOrReferenceId);
        if (taskDescriptor.isPresent()) {
            boolean result = this.taskService.removeTaskDescriptor(taskDescriptor.get());
            this.ok(result);
        } else {
            this.fail("Invalid or ambiguous id argument");
        }
    }

    @CmdAdvisor(description="list all available identified runnables")
    public void __task_runnable_list() {
        List<IIdentifiedRunnable> availableRunnables = this.taskService.getIdentifiedRunnables();
        this.prflp("Runnable ID", 30);
        this.prflp("Bundle", 60);
        this.ci.print((Object)"Description\n");
        availableRunnables.stream().sorted(Comparator.comparing(ii -> ii.getId())).forEach(ii -> {
            this.prflp(ii.getId(), 30);
            String classNameShortened = this.abbreviatePackageNames(ii.getClass().getName());
            this.prflp(classNameShortened, 60);
            this.ci.print((Object)(String.valueOf(ii.getLocalizedDescription()) + "\n"));
        });
    }

    private String abbreviatePackageNames(String name) {
        return name.replace("ch.elexis", "c.e").replace("ch.medelexis", "c.m").replace("at.medevit", "a.m").replace("core", "c");
    }
}

