/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.views.rechnung.RechnungsListeView;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Tree;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public class RnMenuListener
implements IMenuListener {
    RechnungsListeView view;
    private int generalStatus;

    RnMenuListener(RechnungsListeView view) {
        this.view = view;
    }

    public void menuAboutToShow(IMenuManager manager) {
        Object[] o = this.view.cv.getSelection();
        if (o != null && o.length > 0) {
            if (o.length == 1) {
                Tree t = (Tree)o[0];
                if (t.contents instanceof Rechnung) {
                    Rechnung rn = (Rechnung)t.contents;
                    if (rn.getStatus() == 22) {
                        manager.add((IAction)this.view.actions.delRnAction);
                        manager.add((IAction)this.view.actions.reactivateRnAction);
                    } else {
                        ((RestrictedAction)this.view.actions.changeStatusAction).reflectRight();
                        manager.add((IAction)this.view.actions.rnExportAction);
                        manager.add((IAction)this.view.actions.addPaymentAction);
                        manager.add((IAction)this.view.actions.addExpenseAction);
                        manager.add((IAction)this.view.actions.increaseLevelAction);
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)this.view.actions.changeStatusAction);
                        manager.add((IAction)this.view.actions.stornoAction);
                        this.enableStornoDependentFields(rn.getStatus() != 18);
                    }
                } else if (t.contents instanceof Fall) {
                    manager.add((IAction)this.view.actions.editCaseAction);
                } else if (t.contents instanceof Patient) {
                    manager.add((IAction)this.view.actions.patDetailAction);
                }
            } else {
                ArrayList rechnungen = new ArrayList();
                this.generalStatus = -1;
                boolean compatibleStatus = true;
                Object[] objectArray = o;
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    Tree treeElement = (Tree)obj;
                    if (treeElement.contents instanceof Rechnung) {
                        Rechnung rn = (Rechnung)treeElement.contents;
                        compatibleStatus = this.isCompatible(rn.getStatus());
                    } else if (treeElement.contents instanceof Fall) {
                        Collection fallRechnungen = treeElement.getChildren();
                        for (Tree tRn : fallRechnungen) {
                            Rechnung rn = (Rechnung)tRn.contents;
                            compatibleStatus = this.isCompatible(rn.getStatus());
                        }
                    } else if (treeElement.contents instanceof Patient) {
                        Collection fallChilds = treeElement.getChildren();
                        for (Tree fallTree : fallChilds) {
                            Collection fallRechnungen = fallTree.getChildren();
                            for (Tree tRn : fallRechnungen) {
                                Rechnung rn = (Rechnung)tRn.contents;
                                compatibleStatus = this.isCompatible(rn.getStatus());
                            }
                        }
                    }
                    ++n2;
                }
                if (compatibleStatus) {
                    if (this.generalStatus == 22) {
                        manager.add((IAction)this.view.actions.delRnAction);
                        manager.add((IAction)this.view.actions.reactivateRnAction);
                    } else {
                        manager.add((IAction)this.view.actions.rnExportAction);
                        manager.add((IAction)this.view.actions.addExpenseAction);
                        manager.add((IAction)this.view.actions.increaseLevelAction);
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)this.view.actions.changeStatusAction);
                        this.enableStornoDependentFields(this.generalStatus != 18);
                    }
                }
            }
        }
    }

    private boolean isCompatible(int status) {
        if (status != 22 && status != 18) {
            status = 0;
        }
        if (this.generalStatus == -1 || this.generalStatus == status) {
            this.generalStatus = status;
            return true;
        }
        return false;
    }

    private void enableStornoDependentFields(boolean enable) {
        this.view.actions.rnExportAction.setEnabled(enable);
        this.view.actions.addPaymentAction.setEnabled(enable);
        this.view.actions.addExpenseAction.setEnabled(enable);
        this.view.actions.increaseLevelAction.setEnabled(enable);
        this.view.actions.stornoAction.setEnabled(enable);
    }
}

