/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.commands.Handler;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AllOrNoneLockRequestingAction;
import ch.elexis.core.ui.locks.AllOrNoneLockRequestingRestrictedAction;
import ch.elexis.core.ui.locks.LockRequestingAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RechnungsListeView;
import ch.elexis.core.ui.views.rechnung.RnControlFieldProvider;
import ch.elexis.core.ui.views.rechnung.RnDialogs;
import ch.elexis.core.ui.views.rechnung.RnFilterDialog;
import ch.elexis.core.ui.views.rechnung.RnListeDruckDialog;
import ch.elexis.core.ui.views.rechnung.RnListeExportDialog;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class RnActions {
    Action rnExportAction;
    Action increaseLevelAction;
    Action addPaymentAction;
    Action addExpenseAction;
    Action changeStatusAction;
    Action stornoAction;
    Action addAccountExcessAction;
    Action editCaseAction;
    Action delRnAction;
    Action reactivateRnAction;
    Action patDetailAction;
    Action expandAllAction;
    Action collapseAllAction;
    Action reloadAction;
    Action mahnWizardAction;
    Action printListeAction;
    Action exportListAction;
    Action rnFilterAction;

    RnActions(final RechnungsListeView view) {
        this.printListeAction = new Action(Messages.RnActions_printListAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.RnActions_printListTooltip);
            }

            public void run() {
                Object[] sel = view.cv.getSelection();
                new RnListeDruckDialog(view.getViewSite().getShell(), sel).open();
            }
        };
        this.mahnWizardAction = new Action(Messages.RnActions_remindersAction){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_remindersTooltip);
                this.setImageDescriptor(Images.IMG_WIZARD.getImageDescriptor());
            }

            public void run() {
                if (!MessageDialog.openConfirm((Shell)view.getViewSite().getShell(), (String)Messages.RnActions_reminderConfirmCaption, (String)Messages.RnActions_reminderConfirmMessage)) {
                    return;
                }
                Handler.execute(view.getViewSite(), "bill.reminder", null);
                view.cfp.clearValues();
                view.cfp.cbStat.setText(RnControlFieldProvider.stats[RnControlFieldProvider.stats.length - 5]);
                view.cfp.fireChangedEvent();
            }
        };
        this.rnExportAction = new Action(Messages.RechnungsListeView_printAction){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RechnungsListeView_printToolTip);
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> list = view.createList();
                new RnOutputDialog(view.getViewSite().getShell(), list).open();
            }
        };
        this.patDetailAction = new Action(Messages.RnActions_patientDetailsAction){

            public void run() {
                IWorkbenchPage rnPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    rnPage.showView("ch.elexis.PatDetail_v2");
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.editCaseAction = new Action(Messages.RnActions_edirCaseAction){

            public void run() {
                IWorkbenchPage rnPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    rnPage.showView("ch.elexis.FallDetailView");
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.delRnAction = new AllOrNoneLockRequestingAction<Rechnung>(Messages.RnActions_deleteBillAction){

            @Override
            public List<Rechnung> getTargetedObjects() {
                return view.createList();
            }

            @Override
            public void doRun(List<Rechnung> lockedElements) {
                for (Rechnung rn : lockedElements) {
                    rn.storno(true);
                }
            }
        };
        this.reactivateRnAction = new AllOrNoneLockRequestingAction<Rechnung>(Messages.RnActions_reactivateBillAction){

            @Override
            public List<Rechnung> getTargetedObjects() {
                return view.createList();
            }

            @Override
            public void doRun(List<Rechnung> lockedElements) {
                for (Rechnung rn : lockedElements) {
                    rn.setStatus(4);
                }
            }
        };
        this.expandAllAction = new Action(Messages.RnActions_expandAllAction){

            public void run() {
                view.cv.getViewerWidget().getControl().setRedraw(false);
                ((TreeViewer)view.cv.getViewerWidget()).expandAll();
                view.cv.getViewerWidget().getControl().setRedraw(true);
            }
        };
        this.collapseAllAction = new Action(Messages.RnActions_collapseAllAction){

            public void run() {
                view.cv.getViewerWidget().getControl().setRedraw(false);
                ((TreeViewer)view.cv.getViewerWidget()).collapseAll();
                view.cv.getViewerWidget().getControl().setRedraw(true);
            }
        };
        this.reloadAction = new Action(Messages.RnActions_reloadAction){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_reloadTooltip);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                view.cfp.fireChangedEvent();
            }
        };
        this.addPaymentAction = new Action(Messages.RnActions_addBookingAction){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_addBookingTooltip);
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> list = view.createList();
                if (list.size() > 0) {
                    Rechnung actRn = list.get(0);
                    try {
                        if (new RnDialogs.BuchungHinzuDialog(view.getViewSite().getShell(), actRn).open() == 0) {
                            ElexisEventDispatcher.update((PersistentObject)actRn);
                        }
                    }
                    catch (ElexisException e) {
                        SWTHelper.showError("Zahlung hinzuf\u00fcgen ist nicht m\u00f6glich", e.getLocalizedMessage());
                    }
                }
            }
        };
        this.addExpenseAction = new Action(Messages.RnActions_addFineAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> list = view.createList();
                if (!list.isEmpty()) {
                    try {
                        if (list.size() == 1) {
                            Rechnung actRn = list.get(0);
                            if (new RnDialogs.GebuehrHinzuDialog(view.getViewSite().getShell(), actRn).open() == 0) {
                                ElexisEventDispatcher.update((PersistentObject)actRn);
                            }
                        } else if (new RnDialogs.MultiGebuehrHinzuDialog(view.getViewSite().getShell(), list).open() == 0) {
                            for (Rechnung rn : list) {
                                ElexisEventDispatcher.update((PersistentObject)rn);
                            }
                        }
                    }
                    catch (ElexisException e) {
                        SWTHelper.showError("Zahlung hinzuf\u00fcgen ist nicht m\u00f6glich", e.getLocalizedMessage());
                    }
                }
            }
        };
        this.changeStatusAction = new AllOrNoneLockRequestingRestrictedAction<Rechnung>(AccessControlDefaults.ADMIN_CHANGE_BILLSTATUS_MANUALLY, Messages.RnActions_changeStateAction){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.RnActions_changeStateTooltip);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            @Override
            public List<Rechnung> getTargetedObjects() {
                return view.createList();
            }

            @Override
            public void doRun(List<Rechnung> list) {
                if (list.size() == 1) {
                    Rechnung actRn = list.get(0);
                    if (new RnDialogs.StatusAendernDialog(view.getViewSite().getShell(), actRn).open() == 0) {
                        ElexisEventDispatcher.update((PersistentObject)actRn);
                    }
                } else if (new RnDialogs.MultiStatusAendernDialog(view.getViewSite().getShell(), list).open() == 0) {
                    for (Rechnung rn : list) {
                        ElexisEventDispatcher.update((PersistentObject)rn);
                    }
                }
            }
        };
        this.stornoAction = new LockRequestingAction<Rechnung>(Messages.RnActions_stornoAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.RnActions_stornoActionTooltip);
            }

            @Override
            public Rechnung getTargetedObject() {
                List<Rechnung> list = view.createList();
                if (!list.isEmpty()) {
                    return list.get(0);
                }
                return null;
            }

            @Override
            public void doRun(Rechnung actRn) {
                if (new RnDialogs.StornoDialog(view.getViewSite().getShell(), actRn).open() == 0) {
                    ElexisEventDispatcher.update((PersistentObject)actRn);
                }
            }
        };
        this.increaseLevelAction = new Action(Messages.RnActions_increaseReminderLevelAction){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_increadeReminderLevelTooltip);
            }

            public void run() {
                List<Rechnung> list = view.createList();
                if (list.size() > 0) {
                    for (Rechnung actRn : list) {
                        switch (actRn.getStatus()) {
                            case 5: {
                                actRn.setStatus(6);
                                break;
                            }
                            case 7: {
                                actRn.setStatus(8);
                                break;
                            }
                            case 9: {
                                actRn.setStatus(10);
                                break;
                            }
                            default: {
                                SWTHelper.showInfo(Messages.RnActions_changeStateErrorCaption, Messages.RnActions_changeStateErrorMessage);
                            }
                        }
                    }
                }
            }
        };
        this.addAccountExcessAction = new Action(Messages.RnActions_addAccountGood){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_addAccountGoodTooltip);
            }

            public void run() {
                Rechnung actRn;
                Fall fall;
                Patient patient;
                Money prepayment;
                List<Rechnung> list = view.createList();
                if (list.size() > 0 && (prepayment = (patient = (fall = (actRn = list.get(0)).getFall()).getPatient()).getAccountExcess()).getCents() > 0) {
                    Money amount = prepayment.getCents() > actRn.getBetrag().getCents() ? new Money(actRn.getBetrag()) : new Money(prepayment);
                    if (SWTHelper.askYesNo(Messages.RnActions_transferMoneyCaption, "Das Konto von Patient \"" + patient.getLabel() + "\" weist ein positives Kontoguthaben auf. Wollen Sie den Betrag von " + amount.toString() + " dieser Rechnung \"" + actRn.getNr() + ": " + fall.getLabel() + "\" zuweisen?")) {
                        Money accountAmount = new Money(amount);
                        accountAmount.negate();
                        new AccountTransaction(patient, null, accountAmount, null, "Anzahlung von Kontoguthaben auf Rechnung " + actRn.getNr());
                        actRn.addZahlung(amount, "Anzahlung von Kontoguthaben", null);
                    }
                }
            }
        };
        this.rnFilterAction = new Action(Messages.RnActions_filterListAction, 2){
            {
                super($anonymous0, $anonymous1);
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.RnActions_filterLIstTooltip);
            }

            public void run() {
                if (this.isChecked()) {
                    RnFilterDialog rfd = new RnFilterDialog(view.getViewSite().getShell());
                    if (rfd.open() == 0) {
                        view.cntp.setConstraints(rfd.ret);
                        view.cfp.fireChangedEvent();
                    }
                } else {
                    view.cntp.setConstraints(null);
                    view.cfp.fireChangedEvent();
                }
            }
        };
        this.exportListAction = new Action(Messages.RnActions_exportListAction){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_exportListTooltip);
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
            }

            public void run() {
                Object[] sel = view.cv.getSelection();
                new RnListeExportDialog(view.getViewSite().getShell(), sel).open();
            }
        };
    }
}

