/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.data.PersistentObject;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class PersistentObjectDropTarget
implements DropTargetListener,
ICodeSelectorTarget {
    IReceiver rc;
    String name = "";
    private final Color normalColor;
    private final Color highlightColor;
    private final Control mine;

    public PersistentObjectDropTarget(String name, Control target, IReceiver r, boolean colorizeControl) {
        if (colorizeControl) {
            this.normalColor = target.getBackground();
            this.highlightColor = target.getDisplay().getSystemColor(3);
        } else {
            this.normalColor = null;
            this.highlightColor = null;
        }
        this.name = name;
        this.mine = target;
        this.rc = r;
        DropTarget dtarget = new DropTarget(target, 1);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        dtarget.setTransfer(types);
        dtarget.addDropListener((DropTargetListener)this);
    }

    public PersistentObjectDropTarget(Control target, IReceiver r) {
        this("", target, r, true);
    }

    public PersistentObjectDropTarget(String name, Control target, IReceiver r) {
        this(name, target, r, true);
    }

    public void dragEnter(DropTargetEvent event) {
        boolean bOk = false;
        PersistentObject dropped = PersistentObjectDragSource.getDraggedObject();
        if (this.rc.accept(dropped)) {
            bOk = true;
        }
        event.detail = bOk ? 1 : 0;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String[] dl;
        String drp = (String)event.data;
        String[] stringArray = dl = drp.split(",");
        int n = dl.length;
        int n2 = 0;
        while (n2 < n) {
            String obj = stringArray[n2];
            PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
            if (dropped != null) {
                this.rc.dropped(dropped, event);
            }
            ++n2;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.rc.accept(PersistentObjectDragSource.getDraggedObject())) {
            event.detail = 0;
        }
    }

    public void codeSelected(PersistentObject obj) {
        this.rc.dropped(obj, null);
    }

    @Override
    public void codeSelected(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void registered(boolean bIsRegistered) {
        if (this.normalColor != null) {
            this.highlight(bIsRegistered);
        }
    }

    private void highlight(boolean bOn) {
        Control highlightControl = this.getHighLightControl();
        if (!highlightControl.isDisposed()) {
            if (bOn) {
                highlightControl.setBackground(this.highlightColor);
            } else {
                highlightControl.setBackground(this.normalColor);
            }
        }
    }

    protected Control getHighLightControl() {
        return this.mine;
    }

    public static interface IReceiver {
        public void dropped(PersistentObject var1, DropTargetEvent var2);

        public boolean accept(PersistentObject var1);
    }
}

