/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockResponseHelper;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public abstract class AbstractToggleCurrentLockHandler
extends AbstractHandler
implements IElementUpdater {
    protected ICommandService commandService;
    private ElexisEventListenerImpl eventListener = new ElexisUiEventListenerImpl(LockInfo.class, 8){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (AbstractToggleCurrentLockHandler.this.commandService == null) {
                AbstractToggleCurrentLockHandler.this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            }
            AbstractToggleCurrentLockHandler.this.commandService.refreshElements(AbstractToggleCurrentLockHandler.this.getCommandId(), null);
        }
    };

    public abstract String getCommandId();

    public abstract Class<?> getTemplateClass();

    public AbstractToggleCurrentLockHandler() {
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eventListener});
    }

    protected void finalize() throws Throwable {
        ElexisEventDispatcher instance = ElexisEventDispatcher.getInstance();
        if (instance != null) {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eventListener});
        }
        super.finalize();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPersistentObject po;
        if (this.commandService == null) {
            this.commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        }
        if ((po = ElexisEventDispatcher.getSelected(this.getTemplateClass())) == null) {
            this.commandService.refreshElements(this.getCommandId(), null);
            return null;
        }
        if (LocalLockServiceHolder.get().isLockedLocal((Object)po)) {
            LocalLockServiceHolder.get().releaseLock((Object)po);
        } else {
            LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)po);
            if (!lr.isOk()) {
                LockResponseHelper.showInfo(lr, po, null);
            }
        }
        this.commandService.refreshElements(this.getCommandId(), null);
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IPersistentObject po = ElexisEventDispatcher.getSelected(this.getTemplateClass());
        if (po == null) {
            element.setIcon(Images.IMG_LOCK_CLOSED.getImageDescriptor());
            element.setChecked(false);
            return;
        }
        if (LocalLockServiceHolder.get().isLockedLocal((Object)po)) {
            element.setIcon(Images.IMG_LOCK_OPEN.getImageDescriptor());
            element.setChecked(true);
        } else {
            element.setIcon(Images.IMG_LOCK_CLOSED.getImageDescriptor());
            element.setChecked(false);
        }
    }
}

