/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.EpisodeElement;
import ch.elexis.core.ui.exchange.elements.EpisodeRefElement;
import ch.elexis.core.ui.exchange.elements.MedicalElement;
import ch.elexis.core.ui.exchange.elements.RecordElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;

public class AnamnesisElement
extends XChangeElement {
    public static final String XMLNAME = "anamnesis";
    HashMap<IDiagnose, EpisodeElement> hLink = new HashMap();
    HashMap<Element, IDiagnose> hBacklink;
    HashMap<String, Element> hElements;
    MedicalElement eMed;

    public AnamnesisElement(XChangeExporter sender) {
        this.setWriter(sender);
    }

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public List<EpisodeElement> getEpisodes() {
        List<? extends XChangeElement> lep = this.getChildren("episode", EpisodeElement.class);
        return lep;
    }

    public void link(Konsultation k, RecordElement r) {
        ArrayList kdl = k.getDiagnosen();
        for (IDiagnose dg : kdl) {
            EpisodeElement episode = this.hLink.get(dg);
            if (episode == null) {
                episode = new EpisodeElement().asExporter(this.sender, k, dg);
                this.hLink.put(dg, episode);
                this.add(episode);
            }
            EpisodeRefElement episodeRef = new EpisodeRefElement().asExporter(this.sender, episode);
            r.add(episodeRef);
        }
    }

    public void doImport(RecordElement r, Konsultation k) {
        List<? extends XChangeElement> eRefs = r.getChildren("episode", EpisodeElement.class);
        if (eRefs != null) {
            for (EpisodeElement episodeElement : eRefs) {
                IDiagnose dg;
                String id = episodeElement.getAttr("id");
                Element episode = this.hElements.get(id);
                if (episode == null || (dg = this.hBacklink.get(episode)) == null) continue;
                k.addDiagnose(dg);
            }
        }
    }

    public PersistentObject doImport(PersistentObject context) {
        return null;
    }
}

