/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MediDetailDialog
extends TitleAreaDialog {
    private IPrescription prescription;
    private String dosis;
    private String intakeOrder;
    private String disposalComment;
    private Composite stackCompositeDosage;
    private Composite compositeDayTimeDosage;
    private Composite compositeFreeTextDosage;
    private StackLayout stackLayoutDosage;
    private Text txtMorning;
    private Text txtNoon;
    private Text txtEvening;
    private Text txtNight;
    private Text txtFreeText;
    private Text txtIntakeOrder;
    private Text txtDisposalComment;
    private Artikel article;
    private Button btnReserveMedication;
    private String executedFrom;
    private boolean createPrescriptionHistoryEntry;

    public MediDetailDialog(Shell shell, IPrescription prescription) {
        this(shell, prescription, false);
    }

    public MediDetailDialog(Shell shell, IPrescription pr, boolean createPrescriptionHistoryEntry) {
        super(shell);
        this.prescription = pr;
        this.createPrescriptionHistoryEntry = createPrescriptionHistoryEntry;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(3, false));
        this.stackCompositeDosage = new Composite(ret, 0);
        this.stackCompositeDosage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.stackLayoutDosage = new StackLayout();
        this.stackCompositeDosage.setLayout((Layout)this.stackLayoutDosage);
        this.compositeDayTimeDosage = new Composite(this.stackCompositeDosage, 0);
        this.compositeDayTimeDosage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        GridLayout gl_compositeDayTimeDosage = new GridLayout(7, false);
        gl_compositeDayTimeDosage.marginWidth = 0;
        gl_compositeDayTimeDosage.marginHeight = 0;
        gl_compositeDayTimeDosage.verticalSpacing = 1;
        gl_compositeDayTimeDosage.horizontalSpacing = 0;
        this.compositeDayTimeDosage.setLayout((Layout)gl_compositeDayTimeDosage);
        this.compositeFreeTextDosage = new Composite(this.stackCompositeDosage, 0);
        this.compositeFreeTextDosage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        GridLayout gl_compositeFreeTextDosage = new GridLayout(1, false);
        gl_compositeFreeTextDosage.marginWidth = 0;
        gl_compositeFreeTextDosage.marginHeight = 0;
        gl_compositeFreeTextDosage.verticalSpacing = 1;
        gl_compositeFreeTextDosage.horizontalSpacing = 0;
        this.compositeFreeTextDosage.setLayout((Layout)gl_compositeFreeTextDosage);
        GridData gdSignature = new GridData(4, 0x1000000, false, false, 1, 1);
        gdSignature.widthHint = 40;
        this.txtMorning = new Text(this.compositeDayTimeDosage, 2048);
        this.txtMorning.setTextLimit(6);
        this.txtMorning.setMessage(Messages.MediDetailDialog_morning);
        this.txtMorning.setLayoutData((Object)gdSignature);
        new Label(this.compositeDayTimeDosage, 0).setText("-");
        this.txtNoon = new Text(this.compositeDayTimeDosage, 2048);
        this.txtNoon.setTextLimit(6);
        this.txtNoon.setMessage(Messages.MediDetailDialog_lunch);
        this.txtNoon.setLayoutData((Object)gdSignature);
        new Label(this.compositeDayTimeDosage, 0).setText("-");
        this.txtEvening = new Text(this.compositeDayTimeDosage, 2048);
        this.txtEvening.setTextLimit(6);
        this.txtEvening.setMessage(Messages.MediDetailDialog_evening);
        this.txtEvening.setLayoutData((Object)gdSignature);
        new Label(this.compositeDayTimeDosage, 0).setText("-");
        this.txtNight = new Text(this.compositeDayTimeDosage, 2048);
        this.txtNight.setTextLimit(6);
        this.txtNight.setMessage(Messages.MediDetailDialog_night);
        this.txtNight.setLayoutData((Object)gdSignature);
        Button btnDoseSwitch = new Button(ret, 8);
        btnDoseSwitch.setImage(Images.IMG_SYNC.getImage());
        btnDoseSwitch.setToolTipText(Messages.MediDetailDialog_tooltipDosageType);
        btnDoseSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediDetailDialog.this.stackLayoutDosage.topControl = MediDetailDialog.this.stackLayoutDosage.topControl == MediDetailDialog.this.compositeDayTimeDosage ? MediDetailDialog.this.compositeFreeTextDosage : MediDetailDialog.this.compositeDayTimeDosage;
                MediDetailDialog.this.stackCompositeDosage.layout();
            }
        });
        this.txtFreeText = new Text(this.compositeFreeTextDosage, 2048);
        this.txtFreeText.setMessage(Messages.MediDetailDialog_freetext);
        GridData gd_txtFreeText = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtFreeText.widthHint = 210;
        this.txtFreeText.setLayoutData((Object)gd_txtFreeText);
        this.txtFreeText.setTextLimit(255);
        this.btnReserveMedication = new Button(ret, 32);
        this.btnReserveMedication.setText(Messages.MediDetailDialog_btnReserveMedication);
        this.btnReserveMedication.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtIntakeOrder = new Text(ret, 2048);
        this.txtIntakeOrder.setMessage(Messages.MediDetailDialog_intakeOrder);
        this.txtIntakeOrder.setTextLimit(254);
        this.txtIntakeOrder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtDisposalComment = new Text(ret, 2048);
        this.txtDisposalComment.setMessage(Messages.MediDetailDialog_disposalComment);
        this.txtDisposalComment.setTextLimit(254);
        this.txtDisposalComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.stackLayoutDosage.topControl = this.compositeDayTimeDosage;
        if (this.prescription != null) {
            this.initTextFields(this.prescription.getDosageInstruction(), this.prescription.getRemark(), this.prescription.getDisposalComment());
            this.btnReserveMedication.setSelection(this.prescription.getEntryType() == EntryType.RESERVE_MEDICATION);
        }
        this.stackCompositeDosage.layout();
        if ("FixMediDisplay".equals(this.executedFrom)) {
            this.btnReserveMedication.setVisible(false);
        }
        return ret;
    }

    private void initTextFields(String dose, String intakeOrder, String disposalComment) {
        String[] dosage = Prescription.getSignatureAsStringArray((String)dose);
        if (this.isFreeText(dosage)) {
            this.txtFreeText.setText(dosage[0]);
            this.stackLayoutDosage.topControl = this.compositeFreeTextDosage;
        } else {
            this.txtMorning.setText(dosage[0]);
            this.txtNoon.setText(dosage[1]);
            this.txtEvening.setText(dosage[2]);
            this.txtNight.setText(dosage[3]);
            this.stackLayoutDosage.topControl = this.compositeDayTimeDosage;
        }
        this.txtIntakeOrder.setText(intakeOrder == null ? "" : intakeOrder);
        this.txtDisposalComment.setText(disposalComment == null ? "" : disposalComment);
    }

    public void create() {
        super.create();
        if (this.prescription != null) {
            this.setTitle(this.prescription.getArticle().getLabel());
        } else if (this.article != null) {
            this.setTitle(this.article.getLabel());
        }
        this.setMessage(Messages.MediDetailDialog_pleaseEnterPrescription);
        this.getShell().setText(Messages.MediDetailDialog_articleDetail);
    }

    protected void okPressed() {
        this.dosis = this.getDosage();
        this.intakeOrder = this.txtIntakeOrder.getText();
        this.disposalComment = this.txtDisposalComment.getText();
        if (this.prescription != null) {
            AcquireLockBlockingUi.aquireAndRun((Identifiable)this.prescription, new ILockHandler(){

                @Override
                public void lockAcquired() {
                    if (MediDetailDialog.this.createPrescriptionHistoryEntry) {
                        IPrescription oldPrescription = MediDetailDialog.this.prescription;
                        IPrescription newPrescription = MedicationServiceHolder.get().createPrescriptionCopy(oldPrescription);
                        newPrescription.setDosageInstruction(MediDetailDialog.this.dosis);
                        newPrescription.setRemark(MediDetailDialog.this.intakeOrder);
                        newPrescription.setDisposalComment(MediDetailDialog.this.disposalComment);
                        CoreModelServiceHolder.get().save((Identifiable)newPrescription);
                        MedicationServiceHolder.get().stopPrescription(oldPrescription, LocalDateTime.now(), "Ge\u00e4ndert durch " + CoreHub.getLoggedInContact().getLabel());
                        CoreModelServiceHolder.get().save((Identifiable)oldPrescription);
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)newPrescription, Prescription.class, 4)});
                    } else {
                        MediDetailDialog.this.prescription.setDosageInstruction(MediDetailDialog.this.dosis);
                        MediDetailDialog.this.prescription.setRemark(MediDetailDialog.this.intakeOrder);
                        MediDetailDialog.this.prescription.setDisposalComment(MediDetailDialog.this.disposalComment);
                        if (MediDetailDialog.this.btnReserveMedication.getSelection()) {
                            MediDetailDialog.this.prescription.setEntryType(EntryType.RESERVE_MEDICATION);
                        }
                    }
                }

                @Override
                public void lockFailed() {
                }
            });
        }
        super.okPressed();
    }

    public String getDosis() {
        return this.dosis;
    }

    public String getIntakeOrder() {
        return this.intakeOrder;
    }

    private String getDosage() {
        if (this.stackLayoutDosage.topControl == this.compositeDayTimeDosage) {
            String[] values = new String[]{this.txtMorning.getText().isEmpty() ? "0" : this.txtMorning.getText(), this.txtNoon.getText().isEmpty() ? "0" : this.txtNoon.getText(), this.txtEvening.getText().isEmpty() ? "0" : this.txtEvening.getText(), this.txtNight.getText().isEmpty() ? "0" : this.txtNight.getText()};
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < values.length) {
                String string = values[i];
                if (string.length() > 0) {
                    if (i > 0) {
                        sb.append("-");
                    }
                    sb.append(string);
                }
                ++i;
            }
            return sb.toString();
        }
        return this.txtFreeText.getText();
    }

    public String[] getDosageArray(String dosage) {
        Object[] retVal = new String[4];
        Arrays.fill(retVal, "");
        if (dosage != null) {
            if (dosage.matches("^[0-9]/[0-9]$")) {
                retVal[0] = dosage;
            } else if (dosage.matches("[0-9\u00c2\u00bd\u00c2\u00bc]+([xX][0-9]+(/[0-9]+)?|)")) {
                String[] split = dosage.split("[xX]");
                System.arraycopy(split, 0, retVal, 0, split.length);
            } else if (dosage.indexOf(45) != -1) {
                String[] split = dosage.split("[- ]");
                System.arraycopy(split, 0, retVal, 0, split.length);
            }
        }
        return retVal;
    }

    public boolean isFreeText(String[] signatureArray) {
        return !signatureArray[0].isEmpty() && signatureArray[1].isEmpty() && signatureArray[2].isEmpty() && signatureArray[3].isEmpty();
    }

    public void setExecutedFrom(String executedFrom) {
        this.executedFrom = executedFrom;
    }

    public String getExecutedFrom() {
        return this.executedFrom;
    }
}

