/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

public class GenericRange {
    int pos;
    int len;
    public static final int IS_BEFORE_OTHER = 1;
    public static final int IS_AFTER_OTHER = 2;
    public static final int IS_INSIDE_OTHER = 3;
    public static final int IS_AT_BEGIN_OF_OTHER = 4;
    public static final int IS_AT_END_OF_OTHER = 5;
    public static final int IS_OVER_OTHER = 6;
    public static final int IS_ZERO_LENGTH = 7;

    public GenericRange(GenericRange other) {
        this.pos = other.pos;
        this.len = other.len;
    }

    public GenericRange() {
        this.pos = 0;
        this.len = 0;
    }

    public GenericRange(int pos) {
        this.pos = pos;
        this.len = 0;
    }

    public GenericRange(int start, int len) {
        this.pos = start;
        this.len = len;
    }

    public int getLength() {
        return this.len;
    }

    public int getPos() {
        return this.pos;
    }

    public int getEnd() {
        return this.pos + this.len - 1;
    }

    public void setPos(int p) {
        int end = this.getEnd();
        this.pos = p;
        this.setEnd(end);
    }

    public void setLen(int l) {
        this.len = l;
    }

    public void setEnd(int e) {
        this.len = e - this.pos;
    }

    public int positionTo(GenericRange other) {
        if (this.len == 0 || other.len == 0) {
            return 7;
        }
        if (this.pos <= other.pos) {
            if (this.getEnd() <= other.pos) {
                return 1;
            }
            if (this.getEnd() >= other.getEnd()) {
                return 6;
            }
            return 4;
        }
        if (this.getEnd() <= other.getEnd()) {
            return 3;
        }
        if (this.pos >= other.getEnd()) {
            return 2;
        }
        return 5;
    }

    public GenericRange overlap(GenericRange other) {
        GenericRange ret = null;
        switch (this.positionTo(other)) {
            case 1: 
            case 2: 
            case 7: {
                return null;
            }
            case 4: {
                ret = new GenericRange(this.pos);
                ret.setEnd(other.getEnd());
                return ret;
            }
            case 6: {
                return other;
            }
            case 3: {
                return other;
            }
            case 5: {
                ret = new GenericRange(other.getEnd());
                ret.setEnd(this.getEnd());
                return ret;
            }
        }
        return ret;
    }
}

