/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.io.Settings;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class SysSettings
extends Settings {
    private static final long serialVersionUID = -7855039763450972263L;
    public static final int USER_SETTINGS = 0;
    public static final int SYSTEM_SETTINGS = 1;
    volatile int typ;
    volatile Class<?> clazz;
    private static Map<String, SysSettings> instanceMap = new HashMap<String, SysSettings>();

    public static final String Version() {
        return "1.0.2";
    }

    public static synchronized SysSettings getOrCreate(int type, Class<?> cl) {
        String key = String.valueOf(Integer.toString(type)) + "|" + cl.getName();
        if (!instanceMap.containsKey(key)) {
            instanceMap.put(key, new SysSettings(type, cl));
        }
        return instanceMap.get(key);
    }

    public SysSettings(int type, Class<?> cl) {
        this.typ = type;
        this.clazz = cl;
        this.undo();
    }

    private Preferences getRoot() {
        Preferences pr = null;
        pr = this.typ == 0 ? Preferences.userNodeForPackage(this.clazz) : Preferences.systemNodeForPackage(this.clazz);
        String[] nodes = this.getPath().split("/");
        Preferences sub = pr;
        int i = 0;
        while (i < nodes.length) {
            sub = sub.node(nodes[i]);
            ++i;
        }
        return sub;
    }

    public synchronized void write_xml(String file) {
        String errMsg = "\nSysSettings: Error writing: " + file;
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (FileOutputStream os = new FileOutputStream(file);){
                this.getRoot().exportSubtree(os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            log.warn(String.valueOf(e.getMessage()) + errMsg);
        }
        catch (BackingStoreException e) {
            log.warn(String.valueOf(e.getMessage()) + errMsg);
        }
        catch (IOException e) {
            log.warn(String.valueOf(e.getMessage()) + errMsg);
        }
    }

    public synchronized void read_xml(String file) {
        String errMsg = "\nSysSettings: Error reading: " + file;
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (FileInputStream is = new FileInputStream(file);){
                Preferences.importPreferences(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            log.warn(String.valueOf(e.getMessage()) + errMsg);
        }
        catch (InvalidPreferencesFormatException e) {
            log.warn(String.valueOf(e.getMessage()) + errMsg);
        }
        catch (IOException e) {
            log.warn(String.valueOf(e.getMessage()) + errMsg);
        }
    }

    @Override
    protected void flush_absolute() {
        Iterator<String> it = this.iterator();
        Preferences pr = this.getRoot();
        while (it.hasNext()) {
            String a = it.next();
            String[] nodes = a.split("/");
            String key = nodes[nodes.length - 1];
            String value = this.get(a, null);
            Preferences sub = pr;
            Preferences[] plist = new Preferences[nodes.length];
            int i = 0;
            while (i < plist.length - 1) {
                sub = sub.node(nodes[i]);
                ++i;
            }
            if (StringTool.isNothing(value)) {
                sub.remove(key);
                if (this.getSettingChangedListener() == null) continue;
                this.getSettingChangedListener().settingRemoved(key);
                continue;
            }
            sub.put(key, value);
            if (this.getSettingChangedListener() == null) continue;
            this.getSettingChangedListener().settingWritten(key, value);
        }
        try {
            pr.flush();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
        }
    }

    @Override
    public void undo() {
        this.clear();
        this.loadTree(this.getRoot(), "");
    }

    private void loadTree(Preferences root, String path) {
        try {
            String[] subnodes = root.childrenNames();
            path = path.replaceFirst("^/", "");
            int s = 0;
            while (s < subnodes.length) {
                Preferences sub = root.node(subnodes[s]);
                this.loadTree(sub, String.valueOf(path) + "/" + subnodes[s]);
                ++s;
            }
            String[] keys = root.keys();
            int i = 0;
            while (i < keys.length) {
                if (path.equals("")) {
                    this.set(keys[i], root.get(keys[i], ""));
                } else {
                    this.set(String.valueOf(path) + "/" + keys[i], root.get(keys[i], ""));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
        }
    }
}

