/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.util;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import ch.rgw.tools.MimeTool;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentLetterUtil {
    private static Logger logger = LoggerFactory.getLogger(DocumentLetterUtil.class);

    @Nullable
    public static IVirtualFilesystemService.IVirtualFilesystemHandle getExternalHandleIfApplicable(IDocument document) {
        if (document != null) {
            try {
                String path;
                if (document instanceof IDocumentLetter) {
                    IDocumentLetter documentLetter = (IDocumentLetter)document;
                    if (ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false)) {
                        String path2 = DocumentLetterUtil.getOperatingSystemSpecificExternalStoragePath();
                        if (path2 != null) {
                            if (documentLetter.getPatient() != null) {
                                return DocumentLetterUtil.getDocumentLetterFilePath(path2, documentLetter);
                            }
                            if (documentLetter.isTemplate()) {
                                IDocumentTemplate documentTemplate = CoreModelServiceHolder.get().load(documentLetter.getId(), IDocumentTemplate.class).orElse(null);
                                if (documentTemplate != null) {
                                    documentTemplate.setTitle(documentLetter.getTitle());
                                    documentTemplate.setMimeType(documentLetter.getMimeType());
                                    return DocumentLetterUtil.getDocumentTemplateFilePath(path2, documentTemplate);
                                }
                            } else {
                                logger.warn("No patient for [{}]", (Object)documentLetter.getId());
                            }
                        } else {
                            logger.warn("Brief external storage activate with null path");
                        }
                    }
                } else if (document instanceof IDocumentTemplate && ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false) && (path = DocumentLetterUtil.getOperatingSystemSpecificExternalStoragePath()) != null) {
                    return DocumentLetterUtil.getDocumentTemplateFilePath(path, (IDocumentTemplate)document);
                }
            }
            catch (IOException e) {
                logger.warn("Error loading letter [{}]", (Object)document.getId(), (Object)e);
            }
        }
        return null;
    }

    private static IVirtualFilesystemService.IVirtualFilesystemHandle getDocumentLetterFilePath(String path, IDocumentLetter documentLetter) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle basePath = VirtualFilesystemServiceHolder.get().of(path);
        if (basePath.exists() && basePath.canRead() && basePath.canWrite()) {
            IVirtualFilesystemService.IVirtualFilesystemHandle patientSubDir = basePath.subDir(documentLetter.getPatient().getPatientNr());
            patientSubDir = patientSubDir.mkdir();
            IVirtualFilesystemService.IVirtualFilesystemHandle filePath = patientSubDir.subFile(String.valueOf(documentLetter.getId()) + "." + DocumentLetterUtil.evaluateFileExtension(documentLetter.getMimeType()));
            return filePath;
        }
        logger.warn("Base external storage path [{}] does not exist or is not read/writable", (Object)basePath);
        return null;
    }

    private static IVirtualFilesystemService.IVirtualFilesystemHandle getDocumentTemplateFilePath(String externalStoragePath, IDocumentTemplate documentTemplate) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle basePath = VirtualFilesystemServiceHolder.get().of(externalStoragePath);
        if (basePath.exists() && basePath.canRead() && basePath.canWrite()) {
            IVirtualFilesystemService.IVirtualFilesystemHandle templatesSubDir = basePath.subDir("templates");
            templatesSubDir = templatesSubDir.mkdir();
            IVirtualFilesystemService.IVirtualFilesystemHandle typedTemplatesSubDir = null;
            if ("SYS".equals(documentTemplate.getTemplateTyp())) {
                typedTemplatesSubDir = templatesSubDir.subDir("system");
                typedTemplatesSubDir = typedTemplatesSubDir.mkdir();
            } else {
                typedTemplatesSubDir = templatesSubDir.subDir("custom");
                typedTemplatesSubDir = typedTemplatesSubDir.mkdir();
            }
            IVirtualFilesystemService.IVirtualFilesystemHandle templatesFileSubDir = typedTemplatesSubDir;
            if (documentTemplate.getMandator() != null) {
                templatesFileSubDir = typedTemplatesSubDir.subDir(documentTemplate.getMandator().getLabel());
                templatesFileSubDir = templatesFileSubDir.mkdir();
            }
            IVirtualFilesystemService.IVirtualFilesystemHandle filePath = templatesFileSubDir.subFile(String.valueOf(documentTemplate.getId()) + "_" + documentTemplate.getTitle() + "." + DocumentLetterUtil.evaluateFileExtension(documentTemplate.getMimeType()));
            return filePath;
        }
        logger.warn("Base external storage path [{}] does not exist or is not read/writable", (Object)basePath);
        return null;
    }

    public static String getOperatingSystemSpecificExternalStoragePath() {
        String setting;
        CoreUtil.OS operatingSystem = CoreUtil.getOperatingSystemType();
        switch (operatingSystem) {
            case WINDOWS: {
                setting = "briefe/Textmodul_Extern_File_Path_WINDOWS";
                break;
            }
            case MAC: {
                setting = "briefe/Textmodul_Extern_File_Path_MAC";
                break;
            }
            case LINUX: {
                setting = "briefe/Textmodul_Extern_File_Path_LINUX";
                break;
            }
            default: {
                setting = "briefe/Textmodul_Extern_File_Path";
            }
        }
        String path = ConfigServiceHolder.getGlobal((String)setting, null);
        if (path == null) {
            LoggerFactory.getLogger(DocumentLetterUtil.class).warn("No OS specific path set, reverting to generic setting");
            path = ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File_Path", null);
        }
        return path;
    }

    public static String evaluateFileExtension(String input) {
        String ext = MimeTool.getExtension((String)input);
        if (StringUtils.isEmpty((CharSequence)ext) && StringUtils.isEmpty((CharSequence)(ext = FilenameUtils.getExtension((String)input)))) {
            ext = input;
        }
        return ext;
    }
}

