/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Verrechnet;
import ch.elexis.core.jpa.entities.VerrechnetCopy;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.service.holder.StoreToStringServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.rgw.tools.Money;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Billed
extends AbstractIdDeleteModelAdapter<Verrechnet>
implements IdentifiableWithXid,
IBilled {
    private IBillable billable;

    public Billed(Verrechnet entity) {
        super((EntityWithId)entity);
    }

    public String getLabel() {
        return this.getText();
    }

    public IBillable getBillable() {
        Optional<String> storeToString;
        if (this.billable == null && (storeToString = this.getBillableStoreToString()).isPresent()) {
            this.billable = StoreToStringServiceHolder.get().loadFromString(storeToString.get()).orElse(null);
        }
        return this.billable;
    }

    private Optional<String> getBillableStoreToString() {
        String billableClass = ((Verrechnet)this.getEntity()).getKlasse();
        String billableId = ((Verrechnet)this.getEntity()).getLeistungenCode();
        if (StringUtils.isNotBlank((CharSequence)billableClass) && StringUtils.isNotBlank((CharSequence)billableId)) {
            return Optional.of(String.valueOf(billableClass) + "::" + billableId);
        }
        return Optional.empty();
    }

    public void setBillable(IBillable value) {
        String storeToString = (String)StoreToStringServiceHolder.get().storeToString((Identifiable)value).orElseThrow(() -> new IllegalStateException("Could not get store to string for [" + value + "]"));
        String[] split = storeToString.split("::");
        if (split.length > 1) {
            ((Verrechnet)this.getEntityMarkDirty()).setKlasse(split[0]);
            ((Verrechnet)this.getEntityMarkDirty()).setLeistungenCode(split[1]);
            this.billable = value;
        }
    }

    public IEncounter getEncounter() {
        if (((Verrechnet)this.getEntity()).getBehandlung() != null) {
            return ModelUtil.getAdapter((EntityWithId)((Verrechnet)this.getEntity()).getBehandlung(), IEncounter.class);
        }
        return null;
    }

    public void setEncounter(IEncounter value) {
        if (value instanceof AbstractIdModelAdapter) {
            if (this.getEncounter() != null) {
                this.addRefresh((Identifiable)this.getEncounter());
            }
            Behandlung valueEntity = (Behandlung)((AbstractIdModelAdapter)value).getEntity();
            ((Verrechnet)this.getEntityMarkDirty()).setBehandlung(valueEntity);
            this.addRefresh((Identifiable)value);
        }
    }

    public double getAmount() {
        if (this.getSecondaryScale() == 100) {
            return ((Verrechnet)this.getEntity()).getZahl();
        }
        return (double)this.getSecondaryScale() / 100.0;
    }

    public void setAmount(double value) {
        if (value % 1.0 == 0.0) {
            ((Verrechnet)this.getEntityMarkDirty()).setZahl((int)value);
            this.setSecondaryScale(100);
        } else if (!this.isChangedPrice()) {
            ((Verrechnet)this.getEntityMarkDirty()).setZahl(1);
            int scale2 = (int)Math.round(value * 100.0);
            this.setSecondaryScale(scale2);
        } else {
            throw new IllegalStateException("Can not set non integer amount if price was changed");
        }
    }

    public Money getPrice() {
        return new Money(this.getPoints()).multiply(this.getFactor());
    }

    public void setPrice(Money value) {
        if (this.isNonIntegerAmount()) {
            throw new IllegalStateException("Can not set price if non integer amount was set");
        }
        this.setExtInfo("changedPrice", "true");
        this.setPoints(value.getCents());
        this.setSecondaryScale(100);
    }

    public Money getScaledPrice() {
        int cents = Math.toIntExact(Math.round((double)this.getPoints() * this.getFactor() * this.getPrimaryScaleFactor()));
        return new Money(cents);
    }

    public Money getNetPrice() {
        return new Money(((Verrechnet)this.getEntity()).getEk_kosten());
    }

    public void setNetPrice(Money value) {
        if (value != null) {
            ((Verrechnet)this.getEntityMarkDirty()).setEk_kosten(value.getCents());
        } else {
            ((Verrechnet)this.getEntityMarkDirty()).setEk_kosten(0);
        }
    }

    public String getText() {
        return ((Verrechnet)this.getEntity()).getLeistungenText();
    }

    public void setText(String value) {
        ((Verrechnet)this.getEntityMarkDirty()).setLeistungenText(value);
    }

    public int getPoints() {
        return ((Verrechnet)this.getEntity()).getVk_tp();
    }

    public void setPoints(int value) {
        ((Verrechnet)this.getEntityMarkDirty()).setVk_tp(value);
    }

    public double getFactor() {
        String scaleString = ((Verrechnet)this.getEntity()).getVk_scale();
        if (scaleString != null && !scaleString.isEmpty()) {
            try {
                return Double.parseDouble(scaleString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0;
    }

    public void setFactor(double value) {
        ((Verrechnet)this.getEntityMarkDirty()).setVk_scale(Double.toString(value));
    }

    public int getPrimaryScale() {
        return ((Verrechnet)this.getEntity()).getScale();
    }

    public void setPrimaryScale(int value) {
        ((Verrechnet)this.getEntityMarkDirty()).setScale(value);
    }

    public int getSecondaryScale() {
        return ((Verrechnet)this.getEntity()).getScale2();
    }

    public void setSecondaryScale(int value) {
        ((Verrechnet)this.getEntityMarkDirty()).setScale2(value);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public String getCode() {
        IBillable billable = this.getBillable();
        return billable != null ? billable.getCode() : this.getBillableStoreToString().orElse("?");
    }

    public Money getTotal() {
        int cents = Math.toIntExact(Math.round((double)this.getPoints() * this.getFactor() * this.getPrimaryScaleFactor() * this.getSecondaryScaleFactor() * (double)((Verrechnet)this.getEntity()).getZahl()));
        return new Money(cents);
    }

    public boolean isChangedPrice() {
        Object changedPrice = this.getExtInfo("changedPrice");
        if (changedPrice instanceof String) {
            return ((String)changedPrice).equalsIgnoreCase("true");
        }
        if (changedPrice instanceof Boolean) {
            return (Boolean)changedPrice;
        }
        return false;
    }

    public boolean isNonIntegerAmount() {
        if (this.isChangedPrice()) {
            return false;
        }
        return this.getSecondaryScale() != 100;
    }

    public double getPrimaryScaleFactor() {
        if (this.getPrimaryScale() == 0) {
            return 1.0;
        }
        return (double)this.getPrimaryScale() / 100.0;
    }

    public double getSecondaryScaleFactor() {
        if (this.getSecondaryScale() == 0) {
            return 1.0;
        }
        return (double)this.getSecondaryScale() / 100.0;
    }

    public IContact getBiller() {
        return ModelUtil.getAdapter((EntityWithId)((Verrechnet)this.getEntity()).getUser(), IContact.class, true);
    }

    public void setBiller(IContact value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((Verrechnet)this.getEntityMarkDirty()).setUser((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((Verrechnet)this.getEntityMarkDirty()).setUser(null);
        }
    }

    public void copy(IBilled to) {
        if (to instanceof AbstractIdDeleteModelAdapter) {
            EntityWithId toEntity = ((AbstractIdDeleteModelAdapter)to).getEntity();
            if (toEntity instanceof VerrechnetCopy) {
                VerrechnetCopy verrechnetCopy = (VerrechnetCopy)toEntity;
                verrechnetCopy.setKlasse(((Verrechnet)this.getEntity()).getKlasse());
                verrechnetCopy.setLeistungenCode(((Verrechnet)this.getEntity()).getLeistungenCode());
                verrechnetCopy.setLeistungenText(((Verrechnet)this.getEntity()).getLeistungenText());
                verrechnetCopy.setZahl(((Verrechnet)this.getEntity()).getZahl());
                verrechnetCopy.setEk_kosten(((Verrechnet)this.getEntity()).getEk_kosten());
                verrechnetCopy.setVk_tp(((Verrechnet)this.getEntity()).getVk_tp());
                verrechnetCopy.setVk_scale(((Verrechnet)this.getEntity()).getVk_scale());
                verrechnetCopy.setVk_preis(((Verrechnet)this.getEntity()).getVk_preis());
                verrechnetCopy.setScale(((Verrechnet)this.getEntity()).getScale());
                verrechnetCopy.setScale2(((Verrechnet)this.getEntity()).getScale2());
                verrechnetCopy.setBehandlung(((Verrechnet)this.getEntity()).getBehandlung());
                verrechnetCopy.setExtInfo(((Verrechnet)this.getEntity()).getExtInfo());
                verrechnetCopy.setUser(((Verrechnet)this.getEntity()).getUser());
            } else if (toEntity instanceof Verrechnet) {
                Verrechnet verrechnet = (Verrechnet)toEntity;
                verrechnet.setKlasse(((Verrechnet)this.getEntity()).getKlasse());
                verrechnet.setLeistungenCode(((Verrechnet)this.getEntity()).getLeistungenCode());
                verrechnet.setLeistungenText(((Verrechnet)this.getEntity()).getLeistungenText());
                verrechnet.setZahl(((Verrechnet)this.getEntity()).getZahl());
                verrechnet.setEk_kosten(((Verrechnet)this.getEntity()).getEk_kosten());
                verrechnet.setVk_tp(((Verrechnet)this.getEntity()).getVk_tp());
                verrechnet.setVk_scale(((Verrechnet)this.getEntity()).getVk_scale());
                verrechnet.setVk_preis(((Verrechnet)this.getEntity()).getVk_preis());
                verrechnet.setScale(((Verrechnet)this.getEntity()).getScale());
                verrechnet.setScale2(((Verrechnet)this.getEntity()).getScale2());
                verrechnet.setBehandlung(((Verrechnet)this.getEntity()).getBehandlung());
                verrechnet.setExtInfo(((Verrechnet)this.getEntity()).getExtInfo());
                verrechnet.setUser(((Verrechnet)this.getEntity()).getUser());
            }
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.getLabel();
    }
}

