/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Termin;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;

public class Appointment
extends AbstractIdDeleteModelAdapter<Termin>
implements IdentifiableWithXid,
IAppointment {
    private static DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");

    public Appointment(Termin entity) {
        super((EntityWithId)entity);
    }

    public String getReason() {
        return StringUtils.defaultString((String)((Termin)this.getEntity()).getGrund());
    }

    public void setReason(String value) {
        ((Termin)this.getEntityMarkDirty()).setGrund(value);
    }

    public String getState() {
        return StringUtils.defaultString((String)((Termin)this.getEntity()).getTerminStatus());
    }

    public void setState(String value) {
        if (value != null && !value.equals(this.getState())) {
            ((Termin)this.getEntityMarkDirty()).setTerminStatus(value);
            ((Termin)this.getEntityMarkDirty()).setStatusHistory(String.valueOf(this.getStateHistory()) + "\n" + this.toMinutesTimeStamp(LocalDateTime.now()) + ";" + value);
        }
    }

    public String getType() {
        return StringUtils.defaultString((String)((Termin)this.getEntity()).getTerminTyp());
    }

    public void setType(String value) {
        ((Termin)this.getEntityMarkDirty()).setTerminTyp(value);
    }

    public LocalDateTime getStartTime() {
        LocalDate day = ((Termin)this.getEntity()).getTag();
        if (day != null) {
            try {
                int begin = Integer.valueOf(((Termin)this.getEntity()).getBeginn());
                return day.atStartOfDay().plus(Duration.ofMinutes(begin));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setStartTime(LocalDateTime value) {
        if (value != null) {
            ((Termin)this.getEntityMarkDirty()).setTag(value.toLocalDate());
            int begin = value.getHour() * 60 + value.getMinute();
            ((Termin)this.getEntityMarkDirty()).setBeginn(Integer.toString(begin));
        } else {
            ((Termin)this.getEntityMarkDirty()).setTag(null);
            ((Termin)this.getEntityMarkDirty()).setBeginn(null);
        }
    }

    public LocalDateTime getEndTime() {
        Integer duration;
        LocalDateTime start = this.getStartTime();
        if (start != null && (duration = this.getDurationMinutes()) != null) {
            return start.plus(Duration.ofMinutes(duration.intValue()));
        }
        return null;
    }

    public void setEndTime(LocalDateTime value) {
        if (value != null) {
            if (this.getStartTime() != null) {
                long until = this.getStartTime().until(value, ChronoUnit.MINUTES);
                ((Termin)this.getEntityMarkDirty()).setDauer(Long.toString(until));
            } else if (this.getDurationMinutes() != null) {
                this.setStartTime(value.minus(Duration.ofMinutes(this.getDurationMinutes().intValue())));
            } else {
                this.setStartTime(value);
                ((Termin)this.getEntityMarkDirty()).setDauer(Integer.toString(0));
            }
        } else {
            ((Termin)this.getEntity()).setDauer(null);
        }
    }

    public Integer getDurationMinutes() {
        try {
            return Integer.valueOf(((Termin)this.getEntity()).getDauer());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getSchedule() {
        return ((Termin)this.getEntity()).getBereich();
    }

    public void setSchedule(String value) {
        ((Termin)this.getEntityMarkDirty()).setBereich(value);
    }

    public String getCreatedBy() {
        return ((Termin)this.getEntity()).getErstelltVon();
    }

    public void setCreatedBy(String value) {
        if (value != null) {
            value = StringUtils.abbreviate((String)value, (int)25);
        }
        ((Termin)this.getEntityMarkDirty()).setErstelltVon(value);
    }

    public String getSubjectOrPatient() {
        IContact contact;
        if (((Termin)this.getEntity()).getPatId() != null && !((Termin)this.getEntity()).getPatId().contains(" ") && (contact = this.getContact()) != null) {
            if (contact.isPatient()) {
                contact = CoreModelServiceHolder.get().load(((Termin)this.getEntity()).getPatId(), IPatient.class, false, false).orElse(null);
            }
            return contact.getLabel();
        }
        return StringUtils.defaultString((String)((Termin)this.getEntity()).getPatId());
    }

    public void setSubjectOrPatient(String value) {
        ((Termin)this.getEntityMarkDirty()).setPatId(value);
    }

    public int getPriority() {
        return ((Termin)this.getEntity()).getPriority();
    }

    public void setPriority(int value) {
        ((Termin)this.getEntityMarkDirty()).setPriority(value);
    }

    public int getTreatmentReason() {
        return ((Termin)this.getEntity()).getTreatmentReason();
    }

    public void setTreatmentReason(int value) {
        ((Termin)this.getEntityMarkDirty()).setTreatmentReason(value);
    }

    public int getCaseType() {
        return ((Termin)this.getEntity()).getCaseType();
    }

    public void setCaseType(int value) {
        ((Termin)this.getEntityMarkDirty()).setCaseType(value);
    }

    public int getInsuranceType() {
        return ((Termin)this.getEntity()).getInsuranceType();
    }

    public void setInsuranceType(int value) {
        ((Termin)this.getEntityMarkDirty()).setInsuranceType(value);
    }

    public String getLinkgroup() {
        return ((Termin)this.getEntity()).getLinkgroup();
    }

    public void setLinkgroup(String value) {
        ((Termin)this.getEntityMarkDirty()).setLinkgroup(value);
    }

    public String getExtension() {
        return ((Termin)this.getEntity()).getExtension();
    }

    public void setExtension(String value) {
        ((Termin)this.getEntityMarkDirty()).setExtension(value);
    }

    public IContact getContact() {
        return ((Termin)this.getEntity()).getPatId() != null && !((Termin)this.getEntity()).getPatId().contains(" ") ? (IContact)CoreModelServiceHolder.get().load(((Termin)this.getEntity()).getPatId(), IContact.class, false, false).orElse(null) : null;
    }

    public String getCreated() {
        return ((Termin)this.getEntity()).getAngelegt();
    }

    public void setCreated(String value) {
        ((Termin)this.getEntityMarkDirty()).setAngelegt(value);
    }

    public String getLastEdit() {
        return ((Termin)this.getEntity()).getLastedit();
    }

    public void setLastEdit(String value) {
        ((Termin)this.getEntityMarkDirty()).setLastedit(value);
    }

    public String getStateHistory() {
        return StringUtils.defaultString((String)((Termin)this.getEntity()).getStatusHistory());
    }

    public void setStateHistory(String value) {
        ((Termin)this.getEntityMarkDirty()).setStatusHistory(value);
    }

    public String getStateHistoryFormatted(String formatPattern) {
        if (StringUtils.isNotBlank((CharSequence)this.getStateHistory())) {
            String[] lines;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
            StringBuilder sb = new StringBuilder();
            String[] stringArray = lines = this.getStateHistory().split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String[] f = l.split(";");
                if (f.length == 2) {
                    LocalDateTime tt = this.fromMinutesTimeStamp(f[0]);
                    sb.append(formatter.format(tt)).append(": ").append(f[1]).append("\n");
                }
                ++n2;
            }
            return sb.toString();
        }
        return "";
    }

    private LocalDateTime fromMinutesTimeStamp(String timestamp) {
        if (StringUtils.isNotBlank((CharSequence)timestamp) && StringUtils.isNumeric((CharSequence)timestamp)) {
            long minutes = Long.parseLong(timestamp);
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(minutes * 60L), ZoneId.systemDefault());
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(0L), ZoneId.systemDefault());
    }

    private String toMinutesTimeStamp(LocalDateTime localDateTime) {
        long minutes = ZonedDateTime.of(localDateTime, ZoneId.systemDefault()).toEpochSecond() / 60L;
        return Long.toString(minutes);
    }

    public boolean isRecurring() {
        if (!StringUtils.isBlank((CharSequence)this.getLinkgroup())) {
            return CoreModelServiceHolder.get().load(this.getLinkgroup(), IAppointment.class, true).isPresent();
        }
        return false;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        LocalDateTime start = this.getStartTime();
        LocalDateTime end = this.getEndTime();
        sb.append(dayFormatter.format(start)).append(",");
        sb.append(timeFormatter.format(start)).append("-").append(timeFormatter.format(end)).append(" ").append(this.getSubjectOrPatient()).append(" (").append(this.getType()).append(",").append(this.getState()).append(") ");
        return sb.toString();
    }
}

