/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.liquibase;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseDBUpdater {
    private static Logger logger = LoggerFactory.getLogger(LiquibaseDBUpdater.class);
    private String changelogXmlUrl;
    private DataSource dataSource;

    public LiquibaseDBUpdater(DataSource dataSource) {
        this.dataSource = dataSource;
        this.changelogXmlUrl = "/db/elexisdb_master_update.xml";
    }

    public boolean update() {
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
        Liquibase liquibase = null;
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                JdbcConnection database = new JdbcConnection(connection);
                Database targetDb = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)database);
                liquibase = new Liquibase(this.changelogXmlUrl, (ResourceAccessor)resourceAccessor, targetDb);
                logger.info("Updating database [" + connection + "] with liquibase");
                try {
                    liquibase.update("");
                }
                catch (ValidationFailedException e) {
                    logger.info("Validation failed clear checksums and retry");
                    liquibase.clearCheckSums();
                    liquibase.update("");
                }
            }
            catch (SQLException | LiquibaseException e) {
                logger.warn("Exception on DB update.", e);
                try {
                    if (liquibase != null) {
                        liquibase.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (liquibase != null) {
                    liquibase.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }
}

