/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter.auto;

import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(autoApply=true)
public class LocalDateTimeConverter
implements AttributeConverter<LocalDateTime, String> {
    private Logger log = LoggerFactory.getLogger(LocalDateTimeConverter.class);
    private final DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");

    public String convertToDatabaseColumn(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.format(this.yyyyMMddHHmmss);
    }

    public LocalDateTime convertToEntityAttribute(String dateValue) {
        if (dateValue == null || dateValue.length() == 0) {
            return null;
        }
        try {
            switch (dateValue.length()) {
                case 14: {
                    return LocalDateTime.parse(dateValue, this.yyyyMMddHHmmss);
                }
                case 8: {
                    return LocalDate.parse(dateValue, this.yyyyMMdd).atStartOfDay();
                }
            }
            this.log.warn("Using TimeTool to parse [{}]", (Object)dateValue);
            return new TimeTool(dateValue, true).toLocalDateTime();
        }
        catch (TimeTool.TimeFormatException | DateTimeParseException e) {
            this.log.warn("Error parsing [{}], returning null.", (Object)dateValue, (Object)e);
            return null;
        }
    }
}

