/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter;

import ch.elexis.core.model.prescription.EntryType;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class PrescriptionEntryTypeConverter
implements AttributeConverter<EntryType, String> {
    private static final Logger logger = LoggerFactory.getLogger(PrescriptionEntryTypeConverter.class);

    public String convertToDatabaseColumn(EntryType attribute) {
        if (attribute != null) {
            return Integer.toString(attribute.numericValue());
        }
        return null;
    }

    public EntryType convertToEntityAttribute(String dbData) {
        String prescTypeString = dbData;
        int typeNum = -1;
        if (prescTypeString != null && !prescTypeString.isEmpty()) {
            try {
                typeNum = Integer.parseInt(prescTypeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (typeNum != -1) {
            return EntryType.byNumeric((int)typeNum);
        }
        logger.warn("Unknown entry type [" + dbData + "] using UNKNOWN");
        return EntryType.UNKNOWN;
    }
}

