/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.ui.handlers.TaskServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.data.Konsultation;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EncounterUtil {
    private static Map<String, IIdentifiedRunnable> getIdentifiedRunnablesMap() {
        List available = TaskServiceHolder.get().getIdentifiedRunnables();
        if (available != null && !available.isEmpty()) {
            HashMap<String, IIdentifiedRunnable> ret = new HashMap<String, IIdentifiedRunnable>();
            available.stream().forEach(ir -> {
                IIdentifiedRunnable iIdentifiedRunnable = ret.put(ir.getId(), (IIdentifiedRunnable)ir);
            });
            return ret;
        }
        return Collections.emptyMap();
    }

    public static void addMailToEncounter(ITaskDescriptor taskDescriptor) {
        Optional<IEncounter> encounter = EncounterUtil.getActiveEncounter();
        if (encounter.isPresent()) {
            String label = EncounterUtil.getTaskDescriptorText(taskDescriptor);
            Konsultation.load((String)encounter.get().getId()).addXRef("ch.elexis.core.mail.ui.cons", taskDescriptor.getId(), -1, label);
        }
    }

    public static String getTaskDescriptorText(ITaskDescriptor taskDescriptor) {
        StringBuilder sb = new StringBuilder();
        if ("sendMailFromContext".equals(taskDescriptor.getIdentifiedRunnableId())) {
            Optional execution = TaskServiceHolder.get().findLatestExecution(taskDescriptor);
            MailMessage msg = MailMessage.fromMap((Map)((Map)taskDescriptor.getRunContext().get("message")));
            if (msg != null) {
                sb.append("Mail an ").append(msg.getTo());
                execution.ifPresent(task -> sb.append(" versendet " + task.getFinishedAt().format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"))));
                return sb.toString();
            }
        }
        return sb.toString();
    }

    private static Optional<IEncounter> getActiveEncounter() {
        Optional ret = ContextServiceHolder.get().getRootContext().getTyped(IEncounter.class);
        Optional patient = ContextServiceHolder.get().getActivePatient();
        if (ret.isPresent() && patient.isPresent() && ((IEncounter)ret.get()).getCoverage().getPatient().equals(patient.get())) {
            return ret;
        }
        if (patient.isPresent()) {
            ret = EncounterServiceHolder.get().getLatestEncounter((IPatient)patient.get());
            return ret;
        }
        return Optional.empty();
    }
}

