/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model.service;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.ICodingContribution;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.findings.codes.ILocalCodingContribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class CodingService
implements ICodingService {
    private List<ICodingContribution> contributions;
    private ILocalCodingContribution localCoding;

    private Logger getLogger() {
        return LoggerFactory.getLogger(CodingService.class);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    public synchronized void bindFhirTransformer(ICodingContribution contribution) {
        if (this.contributions == null) {
            this.contributions = new ArrayList<ICodingContribution>();
        }
        if (contribution.getCodeSystem() != null && !contribution.getCodeSystem().isEmpty()) {
            this.contributions.add(contribution);
            if (contribution instanceof ILocalCodingContribution) {
                this.localCoding = (ILocalCodingContribution)contribution;
            }
        } else {
            this.getLogger().warn("Contribution " + contribution + " returns no code system. It will be ignored.");
        }
    }

    public void unbindFhirTransformer(ICodingContribution contribution) {
        if (this.contributions == null) {
            this.contributions = new ArrayList<ICodingContribution>();
        }
        this.contributions.remove(contribution);
    }

    public List<String> getAvailableCodeSystems() {
        return this.contributions.stream().map(contribution -> contribution.getCodeSystem()).collect(Collectors.toList());
    }

    public List<ICoding> getAvailableCodes(String system) {
        for (ICodingContribution iCodingContribution : this.contributions) {
            if (!iCodingContribution.getCodeSystem().equals(system)) continue;
            return iCodingContribution.getCodes();
        }
        return Collections.emptyList();
    }

    public Optional<ICoding> getCode(String system, String code) {
        for (ICodingContribution iCodingContribution : this.contributions) {
            if (!iCodingContribution.getCodeSystem().equals(system)) continue;
            return iCodingContribution.getCode(code);
        }
        return Optional.empty();
    }

    public void addLocalCoding(ICoding coding) {
        if (this.localCoding != null) {
            this.localCoding.addCoding(coding);
        }
    }

    public void removeLocalCoding(ICoding coding) {
        if (this.localCoding != null) {
            this.localCoding.removeCoding(coding);
        }
    }

    public String getLabel(ICoding iCoding) {
        String display;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCodesystemShort(iCoding.getSystem()));
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(iCoding.getCode());
        if (sb.length() > 0) {
            sb.append(" ");
        }
        if ((display = iCoding.getDisplay()) == null || display.isEmpty()) {
            display = this.getDisplay(iCoding);
        }
        sb.append(display);
        return sb.toString();
    }

    private String getDisplay(ICoding iCoding) {
        List<ICoding> availableCodes = this.getAvailableCodes(iCoding.getSystem());
        if (availableCodes != null) {
            availableCodes.isEmpty();
        }
        return "";
    }

    public String getShortLabel(ICoding iCoding) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCodesystemShort(iCoding.getSystem())).append(":").append(iCoding.getCode());
        return sb.toString();
    }

    private String getCodesystemShort(String system) {
        int lastIndex = system.lastIndexOf("/");
        if (lastIndex != -1) {
            return system.substring(lastIndex + 1);
        }
        return system;
    }
}

