/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.util;

import ch.elexis.core.services.IContextService;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public class CoreUiUtil {
    private static Logger logger = LoggerFactory.getLogger(CoreUiUtil.class);
    private static Object lock = new Object();
    private static List<Object> delayedInjection = new ArrayList<Object>();
    private static IContextService contextService;

    @Reference
    public void setModelService(IContextService contextService) {
        CoreUiUtil.contextService = contextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    @Optional
    public void subscribeAppStartupComplete(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event, UISynchronize sync) {
        logger.info("APPLICATION STARTUP COMPLETE");
        Object object = lock;
        synchronized (object) {
            Object property = event.getProperty("org.eclipse.e4.data");
            if (property instanceof MApplication) {
                MApplication application = (MApplication)property;
                contextService.getRootContext().setNamed("applicationContext", (Object)application.getContext());
                if (!delayedInjection.isEmpty()) {
                    for (Object object2 : delayedInjection) {
                        sync.asyncExec(() -> CoreUiUtil.injectServices(object2));
                    }
                    delayedInjection.clear();
                }
            }
        }
    }

    private static java.util.Optional<IEclipseContext> getApplicationContext() {
        if (contextService == null) {
            return java.util.Optional.empty();
        }
        return java.util.Optional.ofNullable(contextService.getRootContext().getNamed("applicationContext").orElse(null));
    }

    private static void injectServices(Object object) {
        if (CoreUiUtil.getApplicationContext().isPresent()) {
            try {
                ContextInjectionFactory.inject((Object)object, (IEclipseContext)CoreUiUtil.getApplicationContext().get());
            }
            catch (InjectionException e) {
                logger.warn("Application context injection failure ", (Throwable)e);
            }
        }
    }

    public static void injectServices(Object object, IEclipseContext context) {
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
    }

    public static boolean isActiveControl(Control control) {
        return control != null && !control.isDisposed() && control.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectServicesWithContext(Object object) {
        Object object2 = lock;
        synchronized (object2) {
            if (CoreUiUtil.getApplicationContext().isPresent()) {
                CoreUiUtil.injectServices(object);
            } else {
                delayedInjection.add(object);
            }
        }
    }

    public static void updateFixLayout(MPart part, boolean state) {
        part.setCloseable(state);
        part.setCloseable(!state);
        if (state) {
            if (!part.getTags().contains("NoMove")) {
                part.getTags().add("NoMove");
            }
        } else {
            part.getTags().remove("NoMove");
        }
    }

    public static Color getColorForString(String colorString) {
        colorString = StringUtils.leftPad((String)colorString, (int)6, (char)'0');
        if (!JFaceResources.getColorRegistry().hasValueFor(colorString)) {
            RGB rgb;
            try {
                rgb = new RGB(Integer.parseInt(colorString.substring(0, 2), 16), Integer.parseInt(colorString.substring(2, 4), 16), Integer.parseInt(colorString.substring(4, 6), 16));
            }
            catch (NumberFormatException nex) {
                logger.warn("Error parsing color string [" + colorString + "]", (Throwable)nex);
                rgb = new RGB(100, 100, 100);
            }
            JFaceResources.getColorRegistry().put(colorString, rgb);
        }
        return JFaceResources.getColorRegistry().get(colorString);
    }
}

