/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.Identifiable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;

public interface IFinding
extends Identifiable,
Deleteable {
    public String getId();

    public String getPatientId();

    public void setPatientId(String var1);

    public Optional<String> getText();

    public void setText(String var1);

    public void addStringExtension(String var1, String var2);

    public Map<String, String> getStringExtensions();

    public RawContentFormat getRawContentFormat();

    public String getRawContent();

    public void setRawContent(String var1);

    default public Date getDate(LocalDateTime localDateTime) {
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    default public Date getDate(LocalDate localDate) {
        ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    default public LocalDateTime getLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    default public LocalDate getLocalDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static enum RawContentFormat {
        FHIR_JSON,
        FHIR_XML;

    }
}

