/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.internal;

import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class FhirTransformerRegistry
implements IFhirTransformerRegistry {
    private List<IFhirTransformer<?, ?>> transformers;
    private HashMap<String, IFhirTransformer<?, ?>> cache = new HashMap();

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public synchronized void bindFhirTransformer(IFhirTransformer<?, ?> transformer) {
        if (this.transformers == null) {
            this.transformers = new ArrayList();
        }
        this.transformers.add(transformer);
    }

    public void unbindFhirTransformer(IFhirTransformer<?, ?> transformer) {
        if (this.transformers == null) {
            this.transformers = new ArrayList();
        }
        this.transformers.remove(transformer);
    }

    @Override
    public IFhirTransformer<?, ?> getTransformerFor(Class<?> fhirClazz, Class<?> localClazz) {
        String lookupString = String.valueOf(fhirClazz.getName()) + "-" + localClazz.getName();
        IFhirTransformer<?, ?> ret = this.cache.get(lookupString);
        if (ret == null) {
            for (IFhirTransformer<?, ?> iFhirTransformer : this.transformers) {
                if (!iFhirTransformer.matchesTypes(fhirClazz, localClazz)) continue;
                ret = iFhirTransformer;
                this.cache.put(lookupString, iFhirTransformer);
                break;
            }
        }
        return ret;
    }
}

