/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.AbstractFindingsAccessor;
import ch.elexis.core.findings.util.fhir.accessor.EnumMapping;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.codesystems.ConditionCategory;
import org.slf4j.LoggerFactory;

public class ConditionAccessor
extends AbstractFindingsAccessor {
    private EnumMapping categoryMapping = new EnumMapping((Class<? extends Enum<?>>)ConditionCategory.class, (Enum<?>)ConditionCategory.PROBLEMLISTITEM, (Class<? extends Enum<?>>)ICondition.ConditionCategory.class, (Enum<?>)ICondition.ConditionCategory.PROBLEMLISTITEM);

    public Optional<LocalDate> getDateRecorded(DomainResource resource) {
        Condition fhirCondition = (Condition)resource;
        Date date = fhirCondition.getRecordedDate();
        if (date != null) {
            return Optional.of(this.getLocalDate(date));
        }
        return Optional.empty();
    }

    public void setDateRecorded(DomainResource resource, LocalDate date) {
        Condition fhirCondition = (Condition)resource;
        fhirCondition.setRecordedDate(this.getDate(date));
    }

    public ICondition.ConditionCategory getCategory(DomainResource resource) {
        List coding;
        Condition fhirCondition = (Condition)resource;
        if (!fhirCondition.getCategory().isEmpty() && !(coding = ((CodeableConcept)fhirCondition.getCategory().get(0)).getCoding()).isEmpty()) {
            for (Coding categoryCoding : coding) {
                if (!categoryCoding.getSystem().equals("http://hl7.org/fhir/condition-category") && !categoryCoding.getSystem().equals("http://terminology.hl7.org/CodeSystem/condition-category")) continue;
                return (ICondition.ConditionCategory)this.categoryMapping.getLocalEnumValueByCode(categoryCoding.getCode().toUpperCase());
            }
        }
        return ICondition.ConditionCategory.UNKNOWN;
    }

    public void setCategory(DomainResource resource, ICondition.ConditionCategory category) {
        Condition fhirCondition = (Condition)resource;
        CodeableConcept categoryCode = new CodeableConcept();
        ConditionCategory fhirCategoryCode = (ConditionCategory)this.categoryMapping.getFhirEnumValueByEnum((Enum<?>)category);
        if (fhirCategoryCode != null) {
            categoryCode.setCoding(Collections.singletonList(new Coding(fhirCategoryCode.getSystem(), fhirCategoryCode.toCode(), fhirCategoryCode.getDisplay())));
            fhirCondition.setCategory(Collections.singletonList(categoryCode));
        }
    }

    public ICondition.ConditionStatus getStatus(DomainResource resource) {
        Condition fhirCondition = (Condition)resource;
        CodeableConcept fhirStatus = fhirCondition.getClinicalStatus();
        return this.toConditionStatus(fhirStatus);
    }

    private ICondition.ConditionStatus toConditionStatus(CodeableConcept fhirStatus) {
        String code;
        if (fhirStatus != null && (code = fhirStatus.getCodingFirstRep().getCode()) != null) {
            try {
                return ICondition.ConditionStatus.valueOf((String)code.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                LoggerFactory.getLogger(this.getClass()).warn(code, (Throwable)iae);
            }
        }
        return ICondition.ConditionStatus.UNKNOWN;
    }

    public void setStatus(DomainResource resource, ICondition.ConditionStatus status) {
        Condition fhirCondition = (Condition)resource;
        CodeableConcept fhirCategoryCode = this.toCodeableConcept(status);
        if (fhirCategoryCode != null) {
            fhirCondition.setClinicalStatus(fhirCategoryCode);
        }
    }

    private CodeableConcept toCodeableConcept(ICondition.ConditionStatus status) {
        Coding coding = new Coding("http://terminology.hl7.org/CodeSystem/condition-clinical", status.name().toLowerCase(), null);
        return new CodeableConcept(coding);
    }

    public void setStart(DomainResource resource, String start) {
        Condition fhirCondition = (Condition)resource;
        fhirCondition.setOnset((Type)new StringType(start));
    }

    public Optional<String> getStart(DomainResource resource) {
        Condition fhirCondition = (Condition)resource;
        try {
            if (fhirCondition.hasOnsetDateTimeType()) {
                DateTimeType dateTime = fhirCondition.getOnsetDateTimeType();
                if (dateTime != null) {
                    Date date = (Date)dateTime.getValue();
                    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                    return Optional.of(format.format(date));
                }
            } else if (fhirCondition.hasOnsetStringType()) {
                return Optional.of((String)fhirCondition.getOnsetStringType().getValue());
            }
        }
        catch (FHIRException e) {
            LoggerFactory.getLogger(ConditionAccessor.class).error("Could not access start time.", (Throwable)e);
        }
        return Optional.empty();
    }

    public void setEnd(DomainResource resource, String end) {
        Condition fhirCondition = (Condition)resource;
        fhirCondition.setAbatement((Type)new StringType(end));
    }

    public Optional<String> getEnd(DomainResource resource) {
        Condition fhirCondition = (Condition)resource;
        try {
            if (fhirCondition.hasAbatementDateTimeType()) {
                DateTimeType dateTime = fhirCondition.getAbatementDateTimeType();
                if (dateTime != null) {
                    Date date = (Date)dateTime.getValue();
                    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                    return Optional.of(format.format(date));
                }
            } else if (fhirCondition.hasAbatementStringType()) {
                return Optional.of((String)fhirCondition.getAbatementStringType().getValue());
            }
        }
        catch (FHIRException e) {
            LoggerFactory.getLogger(ConditionAccessor.class).error("Could not access end.", (Throwable)e);
        }
        return Optional.empty();
    }

    public void addNote(DomainResource resource, String text) {
        Condition fhirCondition = (Condition)resource;
        Annotation annotation = new Annotation();
        annotation.setText(text);
        fhirCondition.addNote(annotation);
    }

    public void removeNote(DomainResource resource, String text) {
        Condition fhirCondition = (Condition)resource;
        List<Object> notes = new ArrayList(fhirCondition.getNote());
        notes = notes.stream().filter(annotation -> !text.equals(annotation.getText())).collect(Collectors.toList());
        fhirCondition.setNote(notes);
    }

    public List<String> getNotes(DomainResource resource) {
        Condition fhirCondition = (Condition)resource;
        List notes = fhirCondition.getNote();
        return notes.stream().map(annotation -> annotation.getText()).collect(Collectors.toList());
    }

    public List<ICoding> getCoding(DomainResource resource) {
        Condition fhirCondition = (Condition)resource;
        CodeableConcept codeableConcept = fhirCondition.getCode();
        if (codeableConcept != null) {
            return ModelUtil.getCodingsFromConcept(codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setCoding(DomainResource resource, List<ICoding> coding) {
        Condition fhirCondition = (Condition)resource;
        CodeableConcept codeableConcept = fhirCondition.getCode();
        if (codeableConcept == null) {
            codeableConcept = new CodeableConcept();
        }
        ModelUtil.setCodingsToConcept(codeableConcept, coding);
        fhirCondition.setCode(codeableConcept);
    }

    public void setPatientId(DomainResource resource, String patientId) {
        Condition fhirCondition = (Condition)resource;
        fhirCondition.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
    }
}

