/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.activator;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.rgw.io.Settings;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CoreHubHelper {
    public static String getRevision(boolean withDate, CoreHub plugin) {
        StringBuilder sb = new StringBuilder();
        Bundle bundle = plugin.getBundle();
        Version v = bundle.getVersion();
        sb.append("[Bundle info: ").append(v.toString());
        String check = System.getProperty("inEclipse");
        if (check != null && check.equals("true")) {
            sb.append(" (developer version)");
        }
        if (withDate) {
            long lastModify = bundle.getLastModified();
            TimeTool tt = new TimeTool(lastModify);
            sb.append("; ").append(tt.toString(6));
        }
        sb.append("]");
        return sb.toString();
    }

    public static File getWritableUserDir() {
        if (CoreHub.userDir == null) {
            String userhome = null;
            if (CoreHub.localCfg != null) {
                userhome = CoreHub.localCfg.get("elexis-userDir", null);
            }
            if (userhome == null) {
                userhome = System.getProperty("user.home");
            }
            if (StringTool.isNothing(userhome)) {
                userhome = System.getProperty("java.io.tempdir");
            }
            CoreHub.userDir = new File(userhome, "elexis");
        }
        if (!CoreHub.userDir.exists() && !CoreHub.userDir.mkdirs()) {
            System.err.print("fatal: could not create Userdir");
            MessageEvent.fireLoggedError("Panic exit", "could not create userdir " + CoreHub.userDir.getAbsolutePath());
            System.exit(-5);
        }
        return CoreHub.userDir;
    }

    public static void transformConfigKey(String oldKey, String newKey, boolean isGlobal) {
        Settings settings;
        Settings settings2 = settings = isGlobal ? CoreHub.globalCfg : CoreHub.localCfg;
        if (settings.get(oldKey, null) != null && settings.get(newKey, null) == null) {
            settings.set(newKey, settings.get(oldKey, null));
        }
    }
}

