/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.admin;

import ch.elexis.admin.ACE;
import ch.elexis.admin.AbstractAccessControl;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Role;
import ch.elexis.data.User;
import ch.rgw.tools.JdbcLink;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleBasedAccessControl
extends AbstractAccessControl {
    private static Logger log = LoggerFactory.getLogger(RoleBasedAccessControl.class);
    public static final String QUERY_RIGHT_FOR_USER = "SELECT COUNT(*) FROM RIGHTS_PER_USER WHERE USER_ID LIKE %s AND (";
    public static final String QUERY_RIGHT_FOR_ROLE = "SELECT COUNT(*) FROM RIGHTS_PER_ROLE WHERE ROLE_ID LIKE %s AND (";

    protected static boolean queryRightForUser(@NonNull User u, @NonNull ACE ace) {
        return RoleBasedAccessControl.queryRight(QUERY_RIGHT_FOR_USER, u.getWrappedId(), ace);
    }

    protected static boolean queryRightForRole(Role r, ACE ace) {
        return RoleBasedAccessControl.queryRight(QUERY_RIGHT_FOR_ROLE, r.getWrappedId(), ace);
    }

    protected static boolean queryRightForRoles(List<IRole> roles, @NonNull ACE ace) {
        if (roles != null) {
            for (IRole role : roles) {
                if (!RoleBasedAccessControl.queryRightForRole(Role.load(role.getId()), ace)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean queryRight(String qs, String objId, ACE ace) {
        String queryString = String.format(qs, objId);
        StringBuilder sb = new StringBuilder(queryString);
        List<ACE> parentACEs = ace.getParentChainIncludingSelf();
        int i = 0;
        while (i < parentACEs.size()) {
            ACE a = parentACEs.get(i);
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(" RIGHT_ID = " + JdbcLink.wrap((String)a.getUniqueHashFromACE()));
            ++i;
        }
        sb.append(");");
        JdbcLink.Stm stm = PersistentObject.getConnection().getStatement();
        boolean ret = false;
        try {
            ResultSet result = stm.query(sb.toString());
            boolean step = result.next();
            if (!step) {
                boolean bl = ret;
                return bl;
            }
            try {
                int counts = result.getInt(1);
                ret = counts > 0;
            }
            catch (SQLException e) {
                log.error("Error querying access right ", (Throwable)e);
            }
        }
        finally {
            PersistentObject.getConnection().releaseStatement(stm);
        }
        return ret;
    }

    @Override
    public boolean request(@Nullable ACE ace) {
        return this.request((User)null, ace);
    }

    @Override
    public boolean request(String canonicalName) {
        if (canonicalName == null || canonicalName.length() < 1) {
            return false;
        }
        return this.request(ACE.getACEByCanonicalName(canonicalName));
    }

    @Override
    public boolean request(@Nullable User user, @Nullable ACE ace) {
        if (ace == null) {
            return false;
        }
        if (user == null) {
            IUser iUser = ContextServiceHolder.get().getActiveUser().orElse(null);
            if (iUser == null) {
                log.warn("ACE [{}]request on null user", (Object)ace, (Object)new Throwable());
                return false;
            }
            if (!iUser.isInternal()) {
                return iUser.isAdministrator() || RoleBasedAccessControl.queryRightForRoles(iUser.getRoles(), ace);
            }
            user = User.load(iUser.getId());
        }
        if (user.isAdministrator()) {
            return true;
        }
        return RoleBasedAccessControl.queryRightForUser(user, ace);
    }

    @Override
    public boolean request(@NonNull Role r, @Nullable ACE ace) {
        if (ace == null) {
            return false;
        }
        return RoleBasedAccessControl.queryRightForRole(r, ace);
    }

    @Override
    public void grant(Role r, ACE ace) {
        r.grantAccessRight(ace);
    }

    @Override
    public void revoke(Role r, ACE ace) {
        r.revokeAccessRight(ace);
    }

    @Override
    public void grant(String id, ACE ace) {
        Role r = Role.load(id);
        this.grant(r, ace);
    }
}

