/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.IContactHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MaritalStatus;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class IPatientPatientAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IPatient, Patient> {
    private IContactHelper contactHelper;
    private IModelService coreModelService;
    private IUserService userService;

    public IPatientPatientAttributeMapper(IModelService coreModelService, IXidService xidService, IUserService userService) {
        this.contactHelper = new IContactHelper(coreModelService, xidService, userService);
        this.coreModelService = coreModelService;
    }

    @Override
    public void elexisToFhir(IPatient source, Patient target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt("Patient", source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)source, (DomainResource)target);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        this.mapIdentifiersAndPatientNumber(source, target);
        target.setName(this.contactHelper.getHumanNames((IPerson)source));
        target.setGender(this.contactHelper.getGender(source.getGender()));
        target.setBirthDate(this.contactHelper.getBirthDate((IPerson)source));
        this.mapAddressTelecom(source, target);
        this.mapComments(source, target);
        this.mapMaritalStatus(source, target);
        this.mapRelatedContacts(source, target);
        this.mapContactImage(source, target);
    }

    @Override
    public void fhirToElexis(Patient source, IPatient target) {
        this.mapIdentifiers(source, target);
        this.mapName(source, target);
        this.mapGender(source, target);
        this.mapBirthDate(source, target);
        this.mapAddressTelecom(source, target);
        this.mapComments(source, target);
        this.mapMaritalStatus(source, target);
        this.mapContacts(source, target);
        this.mapContactImage(source, target);
    }

    private void mapContacts(Patient source, IPatient target) {
    }

    private void mapRelatedContacts(IPatient source, Patient target) {
        ArrayList<Patient.ContactComponent> contacts = new ArrayList<Patient.ContactComponent>();
        IContact legalGuardian = source.getLegalGuardian();
        if (legalGuardian != null) {
            Patient.ContactComponent _legalGuardian = new Patient.ContactComponent();
            CodeableConcept addCoding = new CodeableConcept().addCoding(new Coding().setCode("N"));
            _legalGuardian.setRelationship(Collections.singletonList(addCoding));
            _legalGuardian.setId(legalGuardian.getId());
            if (legalGuardian.isPerson()) {
                IPerson legalGuardianPerson = (IPerson)CoreModelServiceHolder.get().load(legalGuardian.getId(), IPerson.class).get();
                List<HumanName> humanNames = this.contactHelper.getHumanNames(legalGuardianPerson);
                _legalGuardian.setName(!humanNames.isEmpty() ? humanNames.get(0) : null);
                Enumerations.AdministrativeGender gender = this.contactHelper.getGender(legalGuardianPerson.getGender());
                _legalGuardian.setGender(gender);
            } else if (legalGuardian.isOrganization()) {
                IOrganization legalGuardianOrganization = (IOrganization)CoreModelServiceHolder.get().load(legalGuardian.getId(), IOrganization.class).get();
                this.contactHelper.getOrganizationName(legalGuardianOrganization);
            }
            List<Address> addresses = this.contactHelper.getAddresses(legalGuardian);
            _legalGuardian.setAddress(!addresses.isEmpty() ? addresses.get(0) : null);
            List<ContactPoint> contactPoints = this.contactHelper.getContactPoints(legalGuardian);
            _legalGuardian.setTelecom(contactPoints);
            contacts.add(_legalGuardian);
        }
        target.setContact(contacts);
    }

    private void mapContactImage(IPatient source, Patient target) {
        IImage image = source.getImage();
        if (image != null) {
            Attachment _image = new Attachment();
            MimeType mimeType = image.getMimeType();
            _image.setContentType(mimeType != null ? mimeType.getContentType() : null);
            _image.setData(image.getImage());
            target.setPhoto(Collections.singletonList(_image));
        }
    }

    private void mapContactImage(Patient source, IPatient target) {
        if (!source.getPhoto().isEmpty()) {
            Attachment fhirImage = (Attachment)source.getPhoto().get(0);
            IImage image = (IImage)this.coreModelService.create(IImage.class);
            image.setDate(LocalDate.now());
            String contentType = fhirImage.getContentTypeElement().asStringValue();
            MimeType mimeType = MimeType.getByContentType((String)contentType);
            image.setMimeType(mimeType);
            image.setImage(fhirImage.getData());
            target.setImage(image);
        } else {
            target.setImage(null);
        }
    }

    private void mapMaritalStatus(IPatient source, Patient target) {
        MaritalStatus maritalStatus = source.getMaritalStatus();
        if (maritalStatus != null) {
            target.setMaritalStatus(new CodeableConcept().addCoding(new Coding().setCode(maritalStatus.getFhirCode())));
        }
    }

    private void mapMaritalStatus(Patient source, IPatient target) {
        CodeableConcept maritalStatus = source.getMaritalStatus();
        if (maritalStatus != null && !maritalStatus.getCoding().isEmpty()) {
            String code = ((Coding)maritalStatus.getCoding().get(0)).getCode();
            target.setMaritalStatus(MaritalStatus.byFhirCodeSafe((String)code));
        }
    }

    private void mapComments(Patient source, IPatient target) {
        List extensionsByUrl = source.getExtensionsByUrl("www.elexis.info/extensions/patient/notes");
        if (!extensionsByUrl.isEmpty()) {
            target.setComment(((Extension)extensionsByUrl.get(0)).getValue().toString());
        }
    }

    private void mapComments(IPatient source, Patient target) {
        Extension elexisPatientNote = new Extension();
        elexisPatientNote.setUrl("www.elexis.info/extensions/patient/notes");
        elexisPatientNote.setValue((Type)new StringType(source.getComment()));
        target.addExtension(elexisPatientNote);
    }

    private void mapAddressTelecom(IPatient source, Patient target) {
        List<Address> addresses = this.contactHelper.getAddresses((IContact)source);
        target.setAddress(addresses);
        List<ContactPoint> contactPoints = this.contactHelper.getContactPoints((IContact)source);
        target.setTelecom(contactPoints);
    }

    private void mapAddressTelecom(Patient source, IPatient target) {
        List addresses = source.getAddress();
        for (Address address : addresses) {
            if (!Address.AddressUse.HOME.equals((Object)address.getUse())) continue;
            target.setCity(address.getCity());
            target.setZip(address.getPostalCode());
            if (!address.getLine().isEmpty()) {
                target.setStreet(((StringType)address.getLine().get(0)).asStringValue());
            }
            Country country = null;
            try {
                country = Country.valueOf((String)address.getCountry());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            target.setCountry(country);
        }
        List telecoms = source.getTelecom();
        for (ContactPoint contactPoint : telecoms) {
            if (ContactPoint.ContactPointSystem.PHONE.equals((Object)contactPoint.getSystem())) {
                if (ContactPoint.ContactPointUse.MOBILE.equals((Object)contactPoint.getUse())) {
                    target.setMobile(contactPoint.getValue());
                    continue;
                }
                if (1 == contactPoint.getRank()) {
                    target.setPhone1(contactPoint.getValue());
                    continue;
                }
                if (2 != contactPoint.getRank()) continue;
                target.setPhone2(contactPoint.getValue());
                continue;
            }
            if (ContactPoint.ContactPointSystem.EMAIL.equals((Object)contactPoint.getSystem())) {
                target.setEmail(contactPoint.getValue());
                continue;
            }
            if (!ContactPoint.ContactPointSystem.FAX.equals((Object)contactPoint.getSystem())) continue;
            target.setFax(contactPoint.getValue());
        }
    }

    private void mapBirthDate(Patient source, IPatient target) {
        if (source.getBirthDate() != null) {
            LocalDateTime dob = source.getBirthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            target.setDateOfBirth(dob);
        }
    }

    private void mapGender(Patient source, IPatient target) {
        Enumerations.AdministrativeGender gender = source.getGender();
        if (gender != null) {
            switch (gender) {
                case FEMALE: {
                    target.setGender(Gender.FEMALE);
                    break;
                }
                case MALE: {
                    target.setGender(Gender.MALE);
                    break;
                }
                case UNKNOWN: {
                    target.setGender(Gender.UNKNOWN);
                    break;
                }
                default: {
                    target.setGender(Gender.UNDEFINED);
                }
            }
        }
    }

    private void mapName(Patient source, IPatient target) {
        List names = source.getName();
        for (HumanName humanName : names) {
            if (!HumanName.NameUse.OFFICIAL.equals((Object)humanName.getUse())) continue;
            target.setFirstName(humanName.getGivenAsSingleString());
            target.setLastName(humanName.getFamily());
            target.setTitel(humanName.getPrefixAsSingleString());
            target.setTitelSuffix(humanName.getSuffixAsSingleString());
        }
    }

    private void mapIdentifiersAndPatientNumber(IPatient source, Patient target) {
        List<Identifier> identifiers = this.contactHelper.getIdentifiers((IContact)source);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)source));
        String patNr = source.getPatientNr();
        Identifier identifier = new Identifier();
        identifier.setSystem(IdentifierSystem.ELEXIS_PATNR.getSystem());
        identifier.setValue(patNr);
        identifiers.add(identifier);
        target.setIdentifier(identifiers);
    }

    private void mapIdentifiers(Patient source, IPatient target) {
        List identifiers = source.getIdentifier();
        for (Identifier identifier : identifiers) {
            if (!"www.ahv.ch/xid".equals(identifier.getSystem())) continue;
            target.addXid("www.ahv.ch/xid", identifier.getValue(), true);
        }
    }

    private Identifier getElexisObjectIdentifier(Identifiable dbObject) {
        Identifier identifier = new Identifier();
        identifier.setSystem(IdentifierSystem.ELEXIS_OBJID.getSystem());
        identifier.setValue(dbObject.getId());
        return identifier;
    }
}

