/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ch.elexis.core.findings.IFinding;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindingsContentHelper {
    private static FhirContext context;
    private IParser jsonParser;
    private IParser xmlParser;

    public FhirContext getFhirContext() {
        if (context == null) {
            context = FhirContext.forR4();
        }
        return context;
    }

    public IParser getJsonParser() {
        if (this.jsonParser == null) {
            this.jsonParser = this.getFhirContext().newJsonParser();
        }
        return this.jsonParser;
    }

    public IParser getXmlParser() {
        if (this.xmlParser == null) {
            this.xmlParser = this.getFhirContext().newXmlParser();
        }
        return this.xmlParser;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FindingsContentHelper.class);
    }

    public Optional<IBaseResource> getResource(IFinding finding) throws DataFormatException {
        IBaseResource resource = null;
        if (finding != null) {
            IFinding.RawContentFormat contentFormat = finding.getRawContentFormat();
            if (contentFormat == IFinding.RawContentFormat.FHIR_JSON) {
                String jsonContent = finding.getRawContent();
                if (jsonContent != null && !jsonContent.isEmpty() && finding.getRawContent() != null && !finding.getRawContent().isEmpty()) {
                    resource = this.getJsonParser().parseResource(finding.getRawContent());
                }
            } else if (contentFormat == IFinding.RawContentFormat.FHIR_XML) {
                String xmlContent = finding.getRawContent();
                if (xmlContent != null && !xmlContent.isEmpty() && finding.getRawContent() != null && !finding.getRawContent().isEmpty()) {
                    resource = this.getXmlParser().parseResource(finding.getRawContent());
                }
            } else {
                this.getLogger().error("Could not get resource because of unknown content format [" + contentFormat + "]");
            }
        }
        return Optional.ofNullable(resource);
    }

    public void setResource(BaseResource resource, IFinding finding) throws DataFormatException {
        IFinding.RawContentFormat contentFormat = finding.getRawContentFormat();
        if (contentFormat == IFinding.RawContentFormat.FHIR_JSON) {
            String jsonContent = finding.getRawContent();
            if (jsonContent != null && !jsonContent.isEmpty() && resource != null) {
                if (resource.getId() == null) {
                    resource.setId((IIdType)new IdType(resource.getClass().getSimpleName(), finding.getId()));
                }
                String resourceJson = this.getJsonParser().encodeResourceToString((IBaseResource)resource);
                finding.setRawContent(resourceJson);
            }
        } else if (contentFormat == IFinding.RawContentFormat.FHIR_XML) {
            String xmlContent = finding.getRawContent();
            if (xmlContent != null && !xmlContent.isEmpty() && resource != null) {
                if (resource.getIdElement() == null) {
                    resource.setId((IIdType)new IdType(resource.getClass().getSimpleName(), finding.getId()));
                }
                String resourceJson = this.getXmlParser().encodeResourceToString((IBaseResource)resource);
                finding.setRawContent(resourceJson);
            }
        } else {
            this.getLogger().error("Could not get resource because of unknown content format [" + contentFormat + "]");
        }
    }
}

