/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.IContactHelper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Practitioner;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PractitionerIMandatorTransformer
implements IFhirTransformer<Practitioner, IMandator> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    @Reference
    private IUserService userService;
    private IContactHelper contactHelper;

    @Activate
    private void activate() {
        this.contactHelper = new IContactHelper(this.modelService, this.xidService, this.userService);
    }

    @Override
    public Optional<Practitioner> getFhirObject(IMandator localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Practitioner practitioner = new Practitioner();
        practitioner.setId((IIdType)new IdDt("Practitioner", localObject.getId()));
        List<Identifier> identifiers = this.contactHelper.getIdentifiers((IContact)localObject);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)localObject));
        practitioner.setIdentifier(identifiers);
        if (localObject.isPerson()) {
            IPerson mandatorPerson = (IPerson)this.modelService.load(localObject.getId(), IPerson.class).get();
            practitioner.setName(this.contactHelper.getHumanNames(mandatorPerson));
            practitioner.setGender(this.contactHelper.getGender(mandatorPerson.getGender()));
            practitioner.setBirthDate(this.contactHelper.getBirthDate(mandatorPerson));
            INamedQuery query = this.modelService.getNamedQuery(IUser.class, new String[]{"kontakt"});
            List usersLocal = query.executeWithParameters(query.getParameterMap(new Object[]{"kontakt", mandatorPerson}));
            if (!usersLocal.isEmpty()) {
                practitioner.setActive(((IUser)usersLocal.get(0)).isActive());
            }
        }
        practitioner.setAddress(this.contactHelper.getAddresses((IContact)localObject));
        practitioner.setTelecom(this.contactHelper.getContactPoints((IContact)localObject));
        return Optional.of(practitioner);
    }

    @Override
    public Optional<IMandator> getLocalObject(Practitioner fhirObject) {
        return null;
    }

    @Override
    public Optional<IMandator> updateLocalObject(Practitioner fhirObject, IMandator localObject) {
        return null;
    }

    @Override
    public Optional<IMandator> createLocalObject(Practitioner fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Practitioner.class.equals(fhirClazz) && IMandator.class.equals(localClazz);
    }
}

