/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.IAppointmentHelper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IModelService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Slot;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AppointmentTerminTransformer
implements IFhirTransformer<Appointment, IAppointment> {
    @Reference(target="(transformer.id=Patient.IPatient)")
    private IFhirTransformer<Patient, IPatient> patientTransformer;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IAppointmentService appointmentService;
    private IAppointmentHelper appointmentHelper;

    @Activate
    private void activate() {
        this.appointmentHelper = new IAppointmentHelper();
    }

    @Override
    public Optional<Appointment> getFhirObject(IAppointment localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional patientContact;
        String patientIdOrSomeString;
        Integer durationMinutes;
        LocalDateTime end;
        Appointment appointment = new Appointment();
        appointment.setId((IIdType)new IdDt(Appointment.class.getSimpleName(), localObject.getId()));
        appointment.getMeta().setVersionId(localObject.getLastupdate().toString());
        appointment.getMeta().setLastUpdated((Date)this.appointmentHelper.getLastUpdateAsDate(localObject.getLastupdate()).orElse(null));
        this.appointmentHelper.mapApplyAppointmentStatus(appointment, localObject);
        appointment.setDescription(this.appointmentHelper.getDescription(localObject));
        LocalDateTime start = localObject.getStartTime();
        if (start != null) {
            Date start_ = Date.from(ZonedDateTime.of(start, ZoneId.systemDefault()).toInstant());
            appointment.setStart(start_);
        }
        if ((end = localObject.getEndTime()) != null) {
            Date end_ = Date.from(ZonedDateTime.of(end, ZoneId.systemDefault()).toInstant());
            appointment.setEnd(end_);
        }
        if ((durationMinutes = localObject.getDurationMinutes()) != null) {
            appointment.setMinutesDuration(durationMinutes.intValue());
        }
        org.hl7.fhir.r4.model.Reference slotReference = new org.hl7.fhir.r4.model.Reference((IIdType)new IdType(Slot.class.getSimpleName(), localObject.getId()));
        appointment.setSlot(Collections.singletonList(slotReference));
        List participant = appointment.getParticipant();
        Optional assignedContact = this.appointmentService.resolveAreaAssignedContact(localObject.getSchedule());
        if (assignedContact.isPresent() && ((IContact)assignedContact.get()).isMandator()) {
            Appointment.AppointmentParticipantComponent hcp = new Appointment.AppointmentParticipantComponent();
            hcp.setActor(new org.hl7.fhir.r4.model.Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), ((IContact)assignedContact.get()).getId())));
            hcp.setRequired(Appointment.ParticipantRequired.REQUIRED);
            hcp.setStatus(Appointment.ParticipationStatus.ACCEPTED);
            participant.add(hcp);
        }
        if (StringUtils.isNotEmpty((CharSequence)(patientIdOrSomeString = localObject.getSubjectOrPatient())) && (patientContact = this.modelService.load(patientIdOrSomeString, IPatient.class)).isPresent()) {
            Appointment.AppointmentParticipantComponent patient = new Appointment.AppointmentParticipantComponent();
            patient.setActor(new org.hl7.fhir.r4.model.Reference((IIdType)new IdDt(Patient.class.getSimpleName(), patientIdOrSomeString)));
            patient.setRequired(Appointment.ParticipantRequired.REQUIRED);
            patient.setStatus(Appointment.ParticipationStatus.ACCEPTED);
            participant.add(patient);
            if (includes.contains(new Include("Appointment:patient"))) {
                patient.getActor().setResource((IBaseResource)this.patientTransformer.getFhirObject((IPatient)patientContact.get()).get());
            }
        }
        return Optional.of(appointment);
    }

    @Override
    public Optional<IAppointment> getLocalObject(Appointment fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.modelService.load(id, IAppointment.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IAppointment> updateLocalObject(Appointment fhirObject, IAppointment localObject) {
        this.appointmentHelper.mapApplyAppointmentStatus(localObject, fhirObject);
        this.modelService.save((Identifiable)localObject);
        return Optional.empty();
    }

    @Override
    public Optional<IAppointment> createLocalObject(Appointment fhirObject) {
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Appointment.class.equals(fhirClazz) && IAppointment.class.equals(localClazz);
    }
}

