/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.scripting;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.ScriptingServiceHolder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.LoggerFactory;

public class FindingsScriptingUtil {
    public static boolean hasScript(IObservation iObservation) {
        return iObservation.getScript().isPresent();
    }

    public static void evaluate(IObservation iObservation) {
        Optional script = iObservation.getScript();
        if (ScriptingServiceHolder.getService() != null && script.isPresent()) {
            String preparedScript = FindingsScriptingUtil.prepareScript((String)script.get(), iObservation);
            try {
                Object result = ScriptingServiceHolder.getService().execute(preparedScript);
                if (result instanceof String) {
                    if (iObservation.getObservationType() == IObservation.ObservationType.TEXT) {
                        iObservation.setStringValue((String)result);
                    } else if (iObservation.getObservationType() == IObservation.ObservationType.NUMERIC) {
                        if (NumberUtils.isNumber((String)((String)result))) {
                            BigDecimal newValue = new BigDecimal((String)result);
                            iObservation.setNumericValue(FindingsScriptingUtil.applyDecimal(newValue, iObservation.getDecimalPlace()), iObservation.getNumericValueUnit().orElse(""));
                        } else {
                            LoggerFactory.getLogger(FindingsScriptingUtil.class).debug("Could not set not numeric result [" + result + "]");
                        }
                    }
                } else if (result instanceof Double && !((Double)result).isNaN()) {
                    if (iObservation.getObservationType() == IObservation.ObservationType.NUMERIC) {
                        BigDecimal newValue = new BigDecimal((Double)result);
                        iObservation.setNumericValue(FindingsScriptingUtil.applyDecimal(newValue, iObservation.getDecimalPlace()), iObservation.getNumericValueUnit().orElse(""));
                    } else if (iObservation.getObservationType() == IObservation.ObservationType.TEXT) {
                        iObservation.setStringValue(new BigDecimal((Double)result).toPlainString());
                    }
                } else if (result instanceof Integer) {
                    if (iObservation.getObservationType() == IObservation.ObservationType.NUMERIC) {
                        BigDecimal newValue = new BigDecimal((Integer)result);
                        iObservation.setNumericValue(FindingsScriptingUtil.applyDecimal(newValue, iObservation.getDecimalPlace()), iObservation.getNumericValueUnit().orElse(""));
                    } else if (iObservation.getObservationType() == IObservation.ObservationType.TEXT) {
                        iObservation.setStringValue(new BigDecimal((Integer)result).toPlainString());
                    }
                } else {
                    LoggerFactory.getLogger(FindingsScriptingUtil.class).debug("Error cant handle script result [" + result + "]");
                }
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(FindingsScriptingUtil.class).debug("Error executing script [" + (String)script.get() + "] " + e.getMessage());
            }
        }
    }

    private static BigDecimal applyDecimal(BigDecimal newValue, int decimalPlace) {
        if (decimalPlace != -1) {
            return newValue.setScale(decimalPlace, RoundingMode.HALF_UP);
        }
        return newValue;
    }

    private static String prepareScript(String script, IObservation iObservation) {
        StringBuffer preparedScript = new StringBuffer();
        Pattern pattern = Pattern.compile("\\[.*?\\]");
        Matcher matcher = pattern.matcher(script);
        while (matcher.find()) {
            String var = matcher.group().replaceAll("[\\[\\]]", "");
            String value = FindingsScriptingUtil.getVarValue(var, iObservation);
            if (value != null && !value.isEmpty()) {
                matcher.appendReplacement(preparedScript, value);
                continue;
            }
            matcher.appendReplacement(preparedScript, matcher.group());
        }
        matcher.appendTail(preparedScript);
        return preparedScript.toString();
    }

    private static String getVarValue(String var, IObservation iObservation) {
        List parents = iObservation.getSourceObservations(IObservationLink.ObservationLinkType.REF);
        for (IObservation parentObservation : parents) {
            String value;
            if (parentObservation.getObservationType() != IObservation.ObservationType.REF || (value = FindingsScriptingUtil.getVarValue(var, parentObservation)) == null || value.isEmpty()) continue;
            return value;
        }
        List children = iObservation.getTargetObseravtions(IObservationLink.ObservationLinkType.REF);
        for (IObservation childObservation : children) {
            Optional<String> code = FindingsScriptingUtil.getLocalCode(childObservation);
            if (code.isPresent() && var.equals(code.get())) {
                String stringValue;
                if (childObservation.getObservationType() == IObservation.ObservationType.NUMERIC) {
                    String numericValue = FindingsScriptingUtil.getNumericValue(childObservation);
                    if (numericValue == null) continue;
                    return numericValue;
                }
                if (childObservation.getObservationType() != IObservation.ObservationType.TEXT || (stringValue = FindingsScriptingUtil.getStringValue(childObservation)) == null) continue;
                return stringValue;
            }
            if (childObservation.getObservationType() != IObservation.ObservationType.COMP) continue;
            List components = childObservation.getComponents();
            for (ObservationComponent observationComponent : components) {
                String numericValue;
                code = FindingsScriptingUtil.getLocalCode(observationComponent);
                if (!code.isPresent() || !var.equals(code.get()) || observationComponent.getTypeFromExtension(IObservation.ObservationType.class) != IObservation.ObservationType.NUMERIC || (numericValue = FindingsScriptingUtil.getNumericValue(childObservation)) == null) continue;
                return numericValue;
            }
        }
        return null;
    }

    private static String getStringValue(IObservation childObservation) {
        return childObservation.getStringValue().orElse(null);
    }

    private static String getNumericValue(IObservation childObservation) {
        Optional numericValue = childObservation.getNumericValue();
        if (numericValue.isPresent()) {
            return String.valueOf(((BigDecimal)numericValue.get()).toPlainString()) + "d";
        }
        return null;
    }

    private static Optional<String> getLocalCode(IObservation iObservation) {
        Optional<ICoding> coding = ModelUtil.getCodeBySystem(iObservation.getCoding(), CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
        if (coding.isPresent()) {
            return Optional.of(coding.get().getCode());
        }
        return Optional.empty();
    }

    private static Optional<String> getLocalCode(ObservationComponent component) {
        Optional<ICoding> coding = ModelUtil.getCodeBySystem(component.getCoding(), CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
        if (coding.isPresent()) {
            return Optional.of(coding.get().getCode());
        }
        return Optional.empty();
    }
}

