/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.swt.SWTException;

public class ResourceExpander {
    public static void setExecutable(File newFile) {
        String[] executables = new String[]{"", "so"};
        if (Arrays.asList(executables).contains(ResourceExpander.getExtension(newFile.getName())) && !newFile.canExecute()) {
            try {
                newFile.setExecutable(true);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public static String getExtension(String filename) {
        Optional<String> ext = Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
        return ext.isPresent() ? ext.get() : "";
    }

    public static Path findResource(Path extractTo, String resource, boolean replace) {
        Path path = extractTo.resolve(resource);
        if (Files.exists(path, new LinkOption[0]) && !replace) {
            return path;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (ResourceExpander.extract(path, resource) && Files.exists(path, new LinkOption[0])) {
                return path;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SWTException(47, "Failed to extract " + resource + "from jar");
        }
        throw new UnsatisfiedLinkError("Could not find resource " + resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean extract(Path extractToFilePath, String resource) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = ResourceExpander.class.getResourceAsStream("/" + resource);){
            if (is == null) return false;
            Files.copy(is, extractToFilePath, StandardCopyOption.REPLACE_EXISTING);
            ResourceExpander.setExecutable(extractToFilePath.toFile());
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    static Path extractFromJar(String chromiumPath, String arch, String subdir, Class<?> fragmentClass) throws IOException {
        Path extractPath = chromiumPath.isEmpty() ? Paths.get(System.getProperty("user.home"), ".equo", "chromium") : Paths.get(chromiumPath, new String[0]);
        extractPath = extractPath.resolve(arch);
        URL url = fragmentClass.getResource("/" + subdir + "/chromium.properties");
        if (url != null) {
            block32: {
                Throwable throwable = null;
                Object var7_8 = null;
                try (InputStream is = url.openStream();){
                    Object object;
                    Properties props = new Properties();
                    props.load(is);
                    String ver = props.getProperty("version");
                    boolean replace = true;
                    Path oldFile = extractPath.resolve(subdir).resolve("chromium.properties");
                    if (Files.exists(oldFile, new LinkOption[0])) {
                        Properties oldProps = new Properties();
                        object = null;
                        Object var15_20 = null;
                        try (BufferedReader oldis = Files.newBufferedReader(oldFile);){
                            oldProps.load(oldis);
                            String oldVer = oldProps.getProperty("version");
                            if (Objects.equals(ver, oldVer)) {
                                replace = false;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (object == null) {
                                object = throwable2;
                            } else if (object != throwable2) {
                                ((Throwable)object).addSuppressed(throwable2);
                            }
                            throw object;
                        }
                    }
                    for (String prop : props.stringPropertyNames()) {
                        if (prop.toLowerCase().contains("version")) continue;
                        String propValue = props.getProperty(prop);
                        ResourceExpander.findResource(extractPath, propValue, replace);
                    }
                    if (!replace) break block32;
                    Throwable throwable3 = null;
                    object = null;
                    try (InputStream propsIs = url.openStream();){
                        Files.copy(propsIs, oldFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            return extractPath;
        }
        return null;
    }
}

