/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.swt.internal.Chromium;
import com.equo.chromium.swt.internal.ResourceExpander;
import com.equo.chromium.swt.internal.spi.DynamicCefSchemeHandlerFactory;
import com.equo.chromium.swt.internal.spi.SchemeDomainPair;
import com.equo.chromium.swt.internal.spi.SchemeHandler;
import com.equo.chromium.swt.internal.spi.SchemeHandlerManager;
import com.equo.chromium.swt.internal.spi.StaticCefSchemeHandlerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.cef.CefApp;
import org.cef.CefAppSwt;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

class Engine {
    private static final String CEFVERSION = "4324";
    private static final String SUBDIR = "chromium-4324";
    private static final String SCHEME_FILE = "file";
    private static Path libsPath;
    static final boolean debug;
    private static boolean shuttingDown;
    private static CefApp app;
    static CompletableFuture<Boolean> ready;
    private static boolean closing;

    static {
        Engine.loadLib();
        debug = Boolean.valueOf(System.getProperty("chromium.debug", "false"));
        ready = new CompletableFuture();
    }

    Engine() {
    }

    private static void loadLib() {
        if (OS.isLinux()) {
            String backend = System.getenv("GDK_BACKEND");
            String session = System.getenv("XDG_SESSION_TYPE");
            if ("wayland".equals(session) && !"x11".equals(backend) && Display.getCurrent() != null) {
                throw new SWTException(47, "To run Chromium on Wayland, set env var GDK_BACKEND=x11 or call ChromiumBrowser.earlyInit() before creating Display");
            }
        }
        libsPath = Engine.findLibsPath().resolve(SUBDIR);
        SystemBootstrap.setLoader(new SystemBootstrap.Loader(){

            @Override
            public void loadLibrary(String libname) {
                System.load(libsPath.resolve(System.mapLibraryName(libname)).toString());
            }
        });
        String[] args = Engine.getChromiumArgs(libsPath);
        if (!Files.exists(libsPath, new LinkOption[0]) || !CefApp.startup(args)) {
            throw new SWTException(47, "Missing binaries for Equo Chromium Browser.");
        }
    }

    private static Path findLibsPath() {
        String binariesBsn;
        block7: {
            String chromiumPath = System.getProperty("chromium.path", "");
            if (!chromiumPath.isEmpty() && Files.exists(Paths.get(chromiumPath, SUBDIR).toAbsolutePath(), new LinkOption[0])) {
                return Paths.get(chromiumPath, new String[0]).toAbsolutePath().normalize();
            }
            String arch = Engine.getArch();
            binariesBsn = "com.equo.chromium.cef." + SWT.getPlatform() + "." + Engine.getOS() + "." + arch;
            try {
                Class<?> fragmentClass = Class.forName("com.equo.chromium.ChromiumFragment");
                CodeSource codeSource = fragmentClass.getProtectionDomain().getCodeSource();
                if (codeSource == null) break block7;
                URI loc = Engine.toURI(codeSource.getLocation());
                Path fragment = Paths.get(loc).toAbsolutePath().normalize();
                try {
                    Path extractPath;
                    if (Files.isRegularFile(fragment, new LinkOption[0]) && (extractPath = ResourceExpander.extractFromJar(chromiumPath, arch, SUBDIR, fragmentClass)) != null) {
                        return extractPath;
                    }
                    Files.walkFileTree(fragment, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            ResourceExpander.setExecutable(file.toFile());
                            return super.visitFile(file, attrs);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return fragment;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        SWTException swtError = new SWTException(47, "plugin/jar '" + binariesBsn + "' is missing and system property 'chromium.path' is not correctly set.");
        throw swtError;
    }

    private static URI toURI(URL url) throws URISyntaxException {
        if (SCHEME_FILE.equals(url.getProtocol())) {
            String pathString = url.toExternalForm().substring(5);
            if (pathString.indexOf(47) != 0) {
                pathString = String.valueOf('/') + pathString;
            }
            return new URI(SCHEME_FILE, null, pathString, null);
        }
        try {
            return new URI(url.toExternalForm());
        }
        catch (URISyntaxException e) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initCEF() {
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            if (app == null) {
                CefSettings settings = new CefSettings();
                try {
                    settings.remote_debugging_port = Integer.parseInt(System.getProperty("chromium.remote_debugging_port", "0"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Path data = Paths.get(System.getProperty("chromium.home", System.getProperty("user.home")), ".equo");
                String cache = data.resolve("cefcache").toAbsolutePath().toString();
                settings.cache_path = System.getProperty("chromium.cache_path", cache);
                settings.log_file = data.resolve("cef.log").toString();
                settings.log_severity = debug ? CefSettings.LogSeverity.LOGSEVERITY_INFO : CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
                boolean external_message_pump = true;
                if (OS.isMacintosh()) {
                    settings.browser_subprocess_path = libsPath.resolve("jcef Helper.app/Contents/MacOS/jcef Helper").toString();
                    settings.resources_dir_path = libsPath.resolve("Chromium Embedded Framework.framework").resolve("Resources").toString();
                    external_message_pump = false;
                } else if (OS.isWindows()) {
                    settings.browser_subprocess_path = libsPath.resolve("jcef_helper.exe").toString();
                    settings.resources_dir_path = libsPath.toString();
                    settings.locales_dir_path = libsPath.resolve("locales").toString();
                } else if (OS.isLinux()) {
                    settings.browser_subprocess_path = libsPath.resolve("jcef_helper").toString();
                    settings.resources_dir_path = libsPath.toString();
                    settings.locales_dir_path = libsPath.resolve("locales").toString();
                    external_message_pump = false;
                }
                settings.external_message_pump = System.getProperty("chromium.external_message_pump") != null ? Boolean.getBoolean("chromium.external_message_pump") : external_message_pump;
                String[] args = Engine.getChromiumArgs(libsPath);
                final SchemeHandlerManager schemeHandlerManager = SchemeHandlerManager.get();
                List<Object> registeredSchemeData = Collections.emptyList();
                if (schemeHandlerManager != null) {
                    registeredSchemeData = schemeHandlerManager.getRegisteredSchemes();
                }
                final List finalRegisteredSchemeData = registeredSchemeData;
                int loopTime = !settings.external_message_pump && !finalRegisteredSchemeData.isEmpty() ? 5 : 33;
                CefAppSwt appSwt = new CefAppSwt(loopTime, settings.external_message_pump);
                CefApp.setWindowingToolkit(appSwt);
                CefApp.addAppHandler(new CefAppHandlerAdapter(args){

                    @Override
                    public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
                        if (!finalRegisteredSchemeData.isEmpty()) {
                            for (SchemeDomainPair schemeDomain : finalRegisteredSchemeData) {
                                String scheme = schemeDomain.getScheme();
                                registrar.addCustomScheme(scheme, true, false, false, true, true, false, true);
                            }
                        }
                    }

                    @Override
                    public void onScheduleMessagePumpWork(long delay_ms) {
                        if (shuttingDown) {
                            Engine.debug("Ignoring onScheduleMessagePumpWork due shuttingDown");
                            return;
                        }
                        super.onScheduleMessagePumpWork(delay_ms);
                    }

                    @Override
                    public void onContextInitialized() {
                        if (!finalRegisteredSchemeData.isEmpty() && app != null) {
                            for (SchemeDomainPair schemeData : finalRegisteredSchemeData) {
                                SchemeHandler schemeHandler = schemeHandlerManager.getSchemeHandler(schemeData.getScheme(), schemeData.getDomain());
                                app.registerSchemeHandlerFactory(schemeData.getScheme(), schemeData.getDomain(), schemeHandler == null ? new DynamicCefSchemeHandlerFactory(schemeHandlerManager) : new StaticCefSchemeHandlerFactory(schemeHandlerManager, schemeData));
                            }
                        }
                        app.registerSchemeHandlerFactory("https", "functions", new CefSchemeHandlerFactory(){

                            @Override
                            public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
                                if (!browser.isPopup()) {
                                    if (this.isPartial(request)) {
                                        return Chromium.getChromium((CefBrowser)browser).functionsResourceHandler.peek();
                                    }
                                    return Chromium.getChromium(browser).createFunctionResourceHandler();
                                }
                                return null;
                            }

                            protected boolean isPartial(CefRequest request) {
                                try {
                                    URI url = new URI(request.getURL());
                                    return url.getFragment() != null;
                                }
                                catch (URISyntaxException e) {
                                    return false;
                                }
                            }
                        });
                        ready.complete(true);
                    }

                    @Override
                    public boolean onBeforeTerminate() {
                        if (shuttingDown) {
                            return false;
                        }
                        shuttingDown = true;
                        Engine.internalShutdown();
                        return true;
                    }
                });
                try {
                    app = CefApp.getInstance(settings);
                }
                catch (UnsatisfiedLinkError e2) {
                    if ("gtk".equals(SWT.getPlatform()) && e2.getMessage().contains("libgconf")) {
                        System.load(libsPath.resolve("libgconf-2.so.4").toString());
                        app = CefApp.getInstance(settings);
                    }
                    throw e2;
                }
                Display.getDefault().addListener(21, e -> {
                    closing = true;
                });
                Display.getDefault().disposeExec(() -> {
                    if (shuttingDown) {
                        return;
                    }
                    if (!OS.isMacintosh() || !closing) {
                        shuttingDown = true;
                        Engine.internalShutdown();
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static String[] getChromiumArgs(Path libsPath) {
        ArrayList<String> args = new ArrayList<String>();
        String vmArg = System.getProperty("chromium.args", System.getProperty("swt.chromium.args"));
        if (vmArg != null) {
            String[] lines = vmArg.replace("\\;", "\\#$").split(";");
            Arrays.stream(lines).map(line -> line.replace("\\#$", ";")).forEach(l -> {
                boolean bl = args.add((String)l);
            });
        }
        if (OS.isLinux()) {
            args.add("--disable-gpu-compositing");
        } else if (OS.isMacintosh()) {
            args.add("--framework-dir-path=" + libsPath.resolve("Chromium Embedded Framework.framework"));
            args.add("--main-bundle-path=" + libsPath.resolve("jcef Helper.app"));
        }
        return args.toArray(new String[args.size()]);
    }

    private static void internalShutdown() {
        if (app == null) {
            return;
        }
        app.dispose();
        app = null;
    }

    static <T extends CefClient> T createClient() {
        return app.createClient();
    }

    private static String getOS() {
        String os = "";
        switch (SWT.getPlatform()) {
            case "gtk": {
                os = "linux";
                break;
            }
            case "win32": {
                os = "win32";
                break;
            }
            case "cocoa": {
                os = "macosx";
            }
        }
        return os;
    }

    private static String getArch() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("i386") || osArch.equals("i686")) {
            return "x86";
        }
        if (osArch.equals("amd64")) {
            return "x86_64";
        }
        return osArch;
    }

    static void debug(String log) {
        if (debug) {
            System.out.println("J:" + log);
        }
    }

    static void debug(String log, CefBrowser cefBrowser) {
        if (debug) {
            int identifier = cefBrowser != null ? cefBrowser.getIdentifier() : -1;
            System.out.println(String.valueOf(System.currentTimeMillis() / 1000L) + ":J" + identifier + ":" + Thread.currentThread().getName() + ":" + log);
        }
    }
}

