/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.stock.dialogs;

import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.LoggerFactory;

public class ImportArticleDialog
extends TitleAreaDialog {
    private ComboViewer comboStockType;
    private Text tFilePath;
    private StringBuffer reportBuilder = null;
    private Link reportLink;

    public ImportArticleDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.reportBuilder = null;
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(3, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(ret, 0).setText("Import in Lager");
        this.comboStockType = new ComboViewer(ret, 2056);
        this.comboStockType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboStockType.setInput((Object)StockServiceHolder.get().getAllStocks(false));
        this.comboStockType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object object = ((StructuredSelection)selection).getFirstElement();
                }
            }
        });
        this.comboStockType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IStock) {
                    IStock stock = (IStock)element;
                    return stock.getLabel();
                }
                return super.getText(element);
            }
        });
        this.comboStockType.getCombo().setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        this.comboStockType.setSelection((ISelection)new StructuredSelection((Object)StockServiceHolder.get().getDefaultStock()));
        new Label(ret, 0).setText("Quelldatei ausw\u00e4hlen");
        this.tFilePath = new Text(ret, 2048);
        this.tFilePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tFilePath.setText("");
        Button btnBrowse = new Button(ret, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ImportArticleDialog.this.getShell(), 4096);
                fd.setFilterExtensions(new String[]{"*.xls"});
                String selected = fd.open();
                ImportArticleDialog.this.tFilePath.setText(selected);
            }
        });
        btnBrowse.setText("ausw\u00e4hlen..");
        this.reportLink = new Link(ret, 0);
        this.reportLink.setText("");
        this.reportLink.setVisible(false);
        this.reportLink.setLayoutData((Object)new GridData(4, 1024, true, true, 3, 1));
        this.reportLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ImportArticleDialog.this.getShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.csv"});
                fd.setFileName("report.csv");
                String path = fd.open();
                if (path != null) {
                    try {
                        FileUtils.writeStringToFile((File)new File(path), (String)ImportArticleDialog.this.reportBuilder.toString(), (String)"UTF-8");
                    }
                    catch (IOException e1) {
                        MessageDialog.openError((Shell)ImportArticleDialog.this.getShell(), (String)"Report Error", (String)("Report konnte nicht gespeichert werden.\n\n" + e1.getMessage()));
                        LoggerFactory.getLogger(ImportArticleDialog.class).error("report save error", (Throwable)e1);
                    }
                }
            }
        });
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle("Artikel Importieren");
        this.setMessage("Bitte w\u00e4hlen Sie die Quelle aus, aus dem Sie die Artikel importieren m\u00f6chten.");
        this.getShell().setText("Artikel Import");
        this.getShell().setImage(Images.IMG_PILL.getImage());
    }

    protected void okPressed() {
        this.reportLink.setVisible(false);
        this.reportBuilder = new StringBuffer();
        this.doImport();
        if (this.reportBuilder.length() > 0) {
            this.reportLink.setText(" <a href=\"\">Import Report vom " + new TimeTool().toString(0) + "</a>");
            this.reportLink.setVisible(true);
        }
    }

    private void doImport() {
        StringBuffer buf = new StringBuffer();
        StructuredSelection iSelection = (StructuredSelection)this.comboStockType.getSelection();
        if (iSelection.isEmpty()) {
            buf.append("Bitte w\u00e4hlen Sie ein Lager aus.");
        } else {
            IStock stock = (IStock)iSelection.getFirstElement();
            String path = this.tFilePath.getText();
            if (path != null && !path.isEmpty() && path.toLowerCase().endsWith("xls")) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileInputStream is = new FileInputStream(this.tFilePath.getText());){
                        ExcelWrapper xl = new ExcelWrapper();
                        if (xl.load((InputStream)is, 0)) {
                            xl.setFieldTypes(new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class});
                            MessageDialog dialog = new MessageDialog(this.getShell(), "Datenimport", null, "Wie sollen die Datenbest\u00e4nde importiert werden ?", 3, 0, new String[]{"Datenbestand 'exakt' importieren", "Datenbestand 'aufaddieren'"});
                            int ret = dialog.open();
                            if (ret >= 0) {
                                this.runImport(buf, stock, xl, ret == 0);
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Import error", (String)("Import fehlgeschlagen.\nDatei nicht importierbar: " + path));
                    LoggerFactory.getLogger(ImportArticleDialog.class).error("cannot import file at " + path, (Throwable)e);
                }
            } else {
                buf.append("Die Quelldatei ist ung\u00fcltig. Bitte \u00fcberpr\u00fcfen Sie diese Datei.\n" + path);
            }
        }
        if (buf.length() > 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Import Ergebnis", (String)buf.toString());
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Import Ergebnis", (String)"Import nicht m\u00f6glich.\n\u00dcberpr\u00fcfen Sie das Log-File.");
        }
    }

    private void runImport(final StringBuffer buf, final IStock stock, final ExcelWrapper xl, final boolean overrideStockEntries) {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
        try {
            progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    int importCount = 0;
                    int articleNotFoundByGtin = 0;
                    int articleNotFoundInStock = 0;
                    int unexpectedErrors = 0;
                    int lastRow = xl.getLastRow();
                    int firstRow = xl.getFirstRow() + 1;
                    monitor.beginTask("Artikel in Lager Import", 100);
                    int i = firstRow;
                    while (i <= lastRow) {
                        Optional<Object> opArticle = Optional.empty();
                        List row = xl.getRow(i);
                        String stockCount = (String)row.get(0);
                        String articleName = (String)row.get(1);
                        String gtin = (String)row.get(6);
                        String stockMin = null;
                        String stockMax = null;
                        if (row.size() > 8) {
                            stockMin = (String)row.get(8);
                        }
                        if (row.size() > 9) {
                            stockMax = (String)row.get(9);
                        }
                        if ((opArticle = ImportArticleDialog.this.findArticleByGtin(gtin)).isPresent()) {
                            String articleStoreToString = (String)StoreToStringServiceHolder.get().storeToString((Identifiable)opArticle.get()).get();
                            IStockEntry stockEntry = StockServiceHolder.get().findStockEntryForArticleInStock(stock, articleStoreToString);
                            String result = "MODIFY";
                            if (stockEntry == null) {
                                stockEntry = StockServiceHolder.get().storeArticleInStock(stock, articleStoreToString);
                                result = "ADDITION";
                            }
                            if (stockEntry instanceof IStockEntry) {
                                if (LocalLockServiceHolder.get().acquireLock((Object)stockEntry).isOk()) {
                                    stockEntry.setCurrentStock(overrideStockEntries ? StringTool.parseSafeInt((String)stockCount) : StringTool.parseSafeInt((String)stockCount) + stockEntry.getCurrentStock());
                                    if (stockMin != null) {
                                        stockEntry.setMinimumStock(StringTool.parseSafeInt((String)stockMin));
                                    }
                                    if (stockMax != null) {
                                        stockEntry.setMaximumStock(StringTool.parseSafeInt((String)stockMax));
                                    }
                                    ++importCount;
                                    ImportArticleDialog.this.addToReport("OK " + result + " '" + stock.getLabel() + "'", articleName, gtin);
                                    CoreModelServiceHolder.get().save((Identifiable)stockEntry);
                                    LocalLockServiceHolder.get().releaseLock((Object)stockEntry);
                                } else {
                                    ImportArticleDialog.this.addToReport("NO LOCK", articleName, gtin);
                                    ++unexpectedErrors;
                                }
                            } else {
                                ImportArticleDialog.this.addToReport("Not in Stock '" + stock.getLabel() + "'", articleName, gtin);
                                ++articleNotFoundInStock;
                            }
                        } else {
                            ++articleNotFoundByGtin;
                            ImportArticleDialog.this.addToReport("Not found by GTIN", articleName, gtin);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            buf.append("Der Import wurde durch den Benutzer abgebrochen.");
                            break;
                        }
                        ++i;
                    }
                    buf.append(lastRow);
                    buf.append(" Artikel gelesen.");
                    buf.append("\n");
                    buf.append("\n");
                    buf.append(importCount);
                    buf.append(" Artikel erfolgreich nach Lager '");
                    buf.append(stock.getLabel());
                    buf.append("' importiert.");
                    buf.append("\n");
                    if (articleNotFoundInStock > 0) {
                        buf.append("\n");
                        buf.append(articleNotFoundInStock);
                        buf.append(" Artikel nicht im Lager '");
                        buf.append(stock.getLabel());
                        buf.append("' vorhanden.");
                    }
                    if (articleNotFoundByGtin > 0) {
                        buf.append("\n");
                        buf.append(articleNotFoundByGtin);
                        buf.append(" Artikel nicht in der Datenbank gefunden.");
                    }
                    if (unexpectedErrors > 0) {
                        buf.append("\n");
                        buf.append(unexpectedErrors);
                        buf.append(" Artikel konnten nicht verarbeitet werden.");
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerFactory.getLogger(ImportArticleDialog.class).warn("Exception during article to lager import.", (Throwable)e);
        }
    }

    private void addToReport(String col1, String col2, String col3) {
        if (this.reportBuilder != null) {
            this.reportBuilder.append(col1);
            this.reportBuilder.append(";");
            this.reportBuilder.append(col2);
            this.reportBuilder.append(";");
            this.reportBuilder.append(col3);
            this.reportBuilder.append("\n");
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeBtn;
        super.createButtonsForButtonBar(parent);
        Button okBtn = super.getButton(0);
        if (okBtn != null) {
            okBtn.setText("Import");
        }
        if ((closeBtn = super.getButton(1)) != null) {
            closeBtn.setText("Schlie\u00dfen");
        }
    }

    private Optional<IArticle> findArticleByGtin(String scanCode) {
        List articleContributions = CodeElementServiceHolder.get().getContributionsByTyp(ICodeElementService.CodeElementTyp.ARTICLE);
        for (ICodeElementServiceContribution contribution : articleContributions) {
            Optional loadFromCode = contribution.loadFromCode(scanCode);
            if (!loadFromCode.isPresent()) continue;
            if (loadFromCode.get() instanceof IArticle) {
                return loadFromCode.map(IArticle.class::cast);
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Found article for gtin [{}] but is not castable to IArticle [{}]", (Object)scanCode, (Object)((ICodeElement)loadFromCode.get()).getClass().getName());
        }
        return Optional.empty();
    }

    protected boolean isResizable() {
        return true;
    }
}

