/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PatientErfassenDialog
extends TitleAreaDialog {
    HashMap<String, String> fld;
    Text tName;
    Text tVorname;
    Text tGebDat;
    Text tStrasse;
    Text tPlz;
    Text tOrt;
    Text tTel;
    Combo cbSex;
    Patient result;

    public Patient getResult() {
        return this.result;
    }

    public PatientErfassenDialog(Shell parent, HashMap<String, String> fields) {
        super(parent);
        this.fld = fields;
    }

    private String getField(String name) {
        String ret = this.fld.get(name);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(2, false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_Name);
        this.tName = new Text(ret, 2048);
        this.tName.setText(this.getField("Name"));
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_firstName);
        this.tVorname = new Text(ret, 2048);
        this.tVorname.setText(this.getField("Vorname"));
        this.tVorname.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_sex);
        this.cbSex = new Combo(ret, 4);
        String toolTip = String.format(Messages.Patient_male_female_tooltip, Messages.Patient_male_short, Messages.Patient_female_short, Messages.Patient_male_long, Messages.Patient_female_long);
        this.cbSex.setToolTipText(toolTip);
        this.cbSex.setItems(new String[]{Messages.Patient_male_short, Messages.Patient_female_short});
        if (StringTool.isNothing((Object)this.getField("Geschlecht"))) {
            this.cbSex.select(0);
        } else {
            this.cbSex.select(StringTool.isFemale((String)this.getField("Vorname")) ? 1 : 0);
        }
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_birthDate);
        this.tGebDat = new Text(ret, 2048);
        this.tGebDat.setText(this.getField("Geburtsdatum"));
        this.tGebDat.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_street);
        this.tStrasse = new Text(ret, 2048);
        this.tStrasse.setText(this.getField("Strasse"));
        this.tStrasse.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_zip);
        this.tPlz = new Text(ret, 2048);
        this.tPlz.setText(this.getField("Plz"));
        this.tPlz.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_city);
        this.tOrt = new Text(ret, 2048);
        this.tOrt.setText(this.getField("Ort"));
        this.tOrt.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.PatientErfassenDialog_phone);
        this.tTel = new Text(ret, 2048);
        this.tTel.setText(this.getField("Telefon1"));
        this.tTel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        return ret;
    }

    public void create() {
        super.create();
        this.setMessage(Messages.PatientErfassenDialog_pleaseEnterPersonalia);
        this.setTitle(Messages.PatientErfassenDialog_enterData);
        this.getShell().setText(Messages.PatientErfassenDialog_enterPatient);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        final String[] ret = new String[8];
        ret[0] = this.tName.getText();
        ret[1] = this.tVorname.getText();
        int idx = this.cbSex.getSelectionIndex();
        if (idx == 1 || this.cbSex.getText().contentEquals(Messages.Patient_female_short)) {
            ret[2] = "w";
        } else if (idx == 0 || this.cbSex.getText().contentEquals(Messages.Patient_male_short)) {
            ret[2] = "m";
        } else if (idx == -1) {
            SWTHelper.showError((String)Messages.PatientErfassenDialog_Error_Sex, (String)Messages.PatientErfassenDialog_Sex_must_be_specified);
            return;
        }
        ret[3] = this.tGebDat.getText();
        try {
            Kontakt k;
            List list;
            TimeTool check = null;
            if (!StringTool.isNothing((Object)ret[3])) {
                check = new TimeTool(ret[3], true);
            }
            ret[4] = this.tStrasse.getText();
            ret[5] = this.tPlz.getText();
            ret[6] = this.tOrt.getText();
            ret[7] = this.tTel.getText();
            Query qbe = new Query(Kontakt.class);
            qbe.add("Bezeichnung1", "=", ret[0], true);
            qbe.add("Bezeichnung2", "=", ret[1], true);
            if (check != null) {
                qbe.add("Geburtsdatum", "=", check.toDBString(false), true);
            }
            if ((list = qbe.execute()) != null && !list.isEmpty() && (k = (Kontakt)list.get(0)).istPerson()) {
                k.set("istPatient", "1");
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.PatientErfassenDialog_personExists, (String)Messages.PatientErfassenDialog_personWithThisNameExists)) {
                    super.cancelPressed();
                    return;
                }
            }
            this.result = new Patient(ret[0], ret[1], check, ret[2]);
            AcquireLockUi.aquireAndRun((IPersistentObject)this.result, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                    PatientErfassenDialog.this.result.delete();
                }

                public void lockAcquired() {
                    PatientErfassenDialog.this.result.set(new String[]{"Strasse", "Plz", "Ort", "Telefon1"}, new String[]{ret[4], ret[5], ret[6], ret[7]});
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)PatientErfassenDialog.this.result);
                }
            });
            super.okPressed();
        }
        catch (TimeTool.TimeFormatException e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.showError((String)"Falsches Datumsformat", (String)"Das Geburtsdatum kann nicht interpretiert werden");
            return;
        }
        catch (Person.PersonDataException pe) {
            ExHandler.handle((Throwable)pe);
            SWTHelper.showError((String)"Unplausible Angaben", (String)("Bitte \u00fcberpr\u00fcfen Sie die Eingabe nochmals: " + pe.getMessage()));
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

