/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.listener;

import ch.elexis.core.jpa.entities.LabOrder;
import ch.elexis.core.jpa.entities.entitymanager.ElexisEntityManagerServiceHolder;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PrePersist;
import javax.persistence.TypedQuery;

public class LabOrderEntityListener {
    @PrePersist
    public void prePersist(LabOrder labOrder) {
        if (labOrder.getOrderid() == null) {
            labOrder.setOrderid(Integer.toString(this.findAndIncrementLabOrderId()));
        }
    }

    private int findAndIncrementLabOrderId() {
        int ret = 0;
        EntityManager em = (EntityManager)ElexisEntityManagerServiceHolder.getEntityManager().getEntityManager(false);
        try {
            em.getTransaction().begin();
            LabOrder version = (LabOrder)em.find(LabOrder.class, (Object)"VERSION");
            if (version == null) {
                version = new LabOrder();
                version.setId("VERSION");
                version.setOrderid("1");
                version.setDeleted(true);
                em.persist((Object)version);
                ret = 1;
            } else {
                em.lock((Object)version, LockModeType.PESSIMISTIC_WRITE);
                ret = Integer.parseInt(version.getOrderid());
                ++ret;
                while (true) {
                    TypedQuery query = em.createNamedQuery("LabOrder.orderid", LabOrder.class);
                    query.setParameter("orderid", (Object)Integer.toString(ret));
                    List results = query.getResultList();
                    if (results.isEmpty()) break;
                    ++ret;
                }
                version.setOrderid(Integer.toString(ret));
            }
            em.getTransaction().commit();
            int n = ret;
            return n;
        }
        finally {
            ElexisEntityManagerServiceHolder.getEntityManager().closeEntityManager((Object)em);
        }
    }
}

