/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.services.IContext;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.text.ITextPlaceholderResolver;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public class TextReplacementService
implements ITextReplacementService {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    private List<ITextPlaceholderResolver> placeholderResolvers;
    private static final String DONT_SHOW_REPLACEMENT_ERRORS = "*";
    public static final String MATCH_TEMPLATE = "\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]";
    private Pattern matchTemplate;

    @Activate
    public void activate() {
        this.matchTemplate = Pattern.compile(MATCH_TEMPLATE);
    }

    private String replacePlaceholder(IContext context, String placeholder) {
        String substring = placeholder.substring(1, placeholder.length() - 1);
        String[] split = substring.split("\\.");
        if (split.length > 1) {
            for (ITextPlaceholderResolver resolver : this.placeholderResolvers) {
                Optional result;
                if (!resolver.getSupportedType().equalsIgnoreCase(split[0]) || !(result = resolver.replaceByTypeAndAttribute(context, substring.substring(split[0].length() + 1))).isPresent()) continue;
                return (String)result.get();
            }
        }
        return "?";
    }

    public List<ITextPlaceholderResolver> getResolvers() {
        return this.placeholderResolvers;
    }

    public String performReplacement(IContext context, String template, String newLinePattern) {
        Matcher matcher = this.matchTemplate.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String found = matcher.group();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.replacePlaceholder(context, found)));
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll("(\r\n|\n\r|\r|\n)", newLinePattern);
    }
}

