/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.stock.ICommissioningSystemDriverFactory;
import ch.elexis.core.services.StockCommissioningSystemService;
import ch.elexis.core.status.StatusUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public class StockCommissioningSystemDriverFactories {
    private Logger log = LoggerFactory.getLogger(StockCommissioningSystemDriverFactories.class);
    private static Map<UUID, ICommissioningSystemDriverFactory> driverFactories = new ConcurrentHashMap<UUID, ICommissioningSystemDriverFactory>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void bind(ICommissioningSystemDriverFactory driverFactory) {
        this.log.debug("Binding " + driverFactory.getClass().getName());
        driverFactories.put(driverFactory.getIdentification(), driverFactory);
    }

    public void unbind(ICommissioningSystemDriverFactory driverFactory) {
        this.log.debug("Unbinding " + driverFactory.getClass().getName());
        this.log.info("Shutting down stock commissioning systems for driver id [{}]", (Object)driverFactory.getIdentification().toString());
        IStatus status = new StockCommissioningSystemService().shutdownInstancesUsingDriver(driverFactory.getIdentification());
        if (!status.isOK()) {
            StatusUtil.logStatus((Logger)this.log, (IStatus)status, (boolean)true);
        }
        driverFactories.remove(driverFactory.getIdentification());
    }

    public static ICommissioningSystemDriverFactory getDriverFactory(UUID driver) {
        return driverFactories.get(driver);
    }

    public static List<UUID> getAllDriverUuids() {
        return new ArrayList<UUID>(driverFactories.keySet());
    }

    public static String getInfoStringForDriver(UUID driverUuid, boolean extended) {
        ICommissioningSystemDriverFactory icsdf = driverFactories.get(driverUuid);
        if (icsdf != null) {
            if (extended) {
                return String.valueOf(icsdf.getName()) + " (" + icsdf.getDescription() + ")";
            }
            return icsdf.getName();
        }
        return "";
    }
}

