/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.ac.ACE;
import ch.elexis.core.ac.AbstractAccessControl;
import ch.elexis.core.ac.AccessControlDefaults;
import ch.elexis.core.ac.IACLContributor;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.internal.RoleBasedAccessControl;
import ch.elexis.core.utils.Extensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class AccessControlService
implements IAccessControlService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    private static Map<String, ACE> allDefinedACEs;
    private static AbstractAccessControl acl;

    @Activate
    private void activate() {
        acl = new RoleBasedAccessControl(this.modelService);
    }

    private void initAllDefinedACEs() {
        if (allDefinedACEs != null) {
            return;
        }
        List temp = this.getACLContributionExtensions().stream().flatMap(acl -> Arrays.asList(acl.getACL()).stream()).collect(Collectors.toList());
        allDefinedACEs = temp.stream().collect(Collectors.toMap(a -> a.getCanonicalName(), a -> a));
    }

    private List<IACLContributor> getACLContributionExtensions() {
        return Extensions.getClasses((String)"ch.elexis.core.data.ACLContribution", (String)"ACLContributor");
    }

    public void initializeDefaults() {
        IRole role = (IRole)this.modelService.load("user", IRole.class).get();
        ACE[] anwender = AccessControlDefaults.getAnwender();
        Arrays.asList(anwender).stream().forEachOrdered(ace -> this.grant(role, (ACE)ace));
        ACE[] alle = AccessControlDefaults.getAlle();
        Arrays.asList(alle).stream().forEachOrdered(ace -> this.grant(role, (ACE)ace));
        this.grant("assistant", AccessControlDefaults.LSTG_CHARGE_FOR_ALL);
        this.grant("assistant", AccessControlDefaults.LSTG_VERRECHNEN);
        this.grant("doctor", AccessControlDefaults.USER);
        this.grant("doctor", AccessControlDefaults.MANDANT);
        this.grant("doctor", AccessControlDefaults.ADMIN_KONS_EDIT_IF_BILLED);
        this.grant("executive_doctor", AccessControlDefaults.ACE_ACCESS);
    }

    public boolean request(ACE ace) {
        return acl.request(ace);
    }

    public boolean request(String canonicalName) {
        if (canonicalName == null || canonicalName.length() < 1) {
            return false;
        }
        ACE aceByCanonicalName = this.getACEByCanonicalName(canonicalName);
        return this.request(aceByCanonicalName);
    }

    private ACE getACEByCanonicalName(String canonicalName) {
        this.initAllDefinedACEs();
        return allDefinedACEs.get(canonicalName);
    }

    public boolean request(IRole r, ACE ace) {
        return acl.request(r, ace);
    }

    public boolean request(IUser u, ACE ace) {
        return acl.request(u, ace);
    }

    public void grant(IRole role, ACE ace) {
        acl.grant(role, ace);
    }

    public void grant(String roleId, ACE ace) {
        Optional role = this.modelService.load(roleId, IRole.class);
        if (role.isPresent()) {
            acl.grant((IRole)role.get(), ace);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Could not grant role [{}] ace [{}]: role not found", (Object)roleId, (Object)ace);
        }
    }

    public void revoke(IRole role, ACE ace) {
        acl.revoke(role, ace);
    }

    public List<ACE> getAllDefinedACElements() {
        this.initAllDefinedACEs();
        return new ArrayList<ACE>(allDefinedACEs.values());
    }
}

