/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.data.Brief;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class Rezept
extends PersistentObject {
    public static final String LINES = "Zeilen";
    public static final String LETTER_ID = "BriefID";
    public static final String DATE = "Datum";
    public static final String MANDATOR_ID = "MandantID";
    public static final String PATIENT_ID = "PatientID";

    static {
        Rezept.addMapping("REZEPTE", PATIENT_ID, MANDATOR_ID, "Datum=S:D:Datum", "Text=RpTxt", LETTER_ID, "Zeilen=LIST:RezeptID:PATIENT_ARTIKEL_JOINT");
    }

    @Override
    protected String getTableName() {
        return "REZEPTE";
    }

    public static Rezept load(String id) {
        return new Rezept(id);
    }

    public Rezept(Patient pat) {
        this.create(null);
        this.set(new String[]{PATIENT_ID, MANDATOR_ID, DATE}, pat.getId(), CoreHub.actMandant.getId(), new TimeTool().toString(4));
    }

    public Patient getPatient() {
        return Patient.load(this.get(PATIENT_ID));
    }

    public Mandant getMandant() {
        Mandant mret = Mandant.load(this.get(MANDATOR_ID));
        return mret;
    }

    public String getDate() {
        return this.get(DATE);
    }

    public String getText() {
        return this.get("Text");
    }

    protected Rezept() {
    }

    protected Rezept(String id) {
        super(id);
    }

    public Brief getBrief() {
        Brief brief = Brief.load(this.get(LETTER_ID));
        if (brief.exists()) {
            return brief;
        }
        return null;
    }

    public void setBrief(Brief brief) {
        if (brief == null) {
            log.error("Null Brief gesetzt bei setBrief");
        } else {
            this.set(LETTER_ID, brief.getId());
        }
    }

    @Override
    public String getLabel() {
        Mandant m = this.getMandant();
        if (m == null) {
            return String.valueOf(this.getDate()) + " (unbekannt)";
        }
        return String.valueOf(this.getDate()) + " " + m.getLabel();
    }

    public List<Prescription> getLines() {
        List<String> list = this.getList(LINES, false);
        ArrayList<Prescription> ret = new ArrayList<Prescription>(list.size());
        for (String s : list) {
            ret.add(Prescription.load(s));
        }
        return ret.stream().sorted((p1, p2) -> Integer.compare(p1.getRecipeOrder(), p2.getRecipeOrder())).collect(Collectors.toList());
    }

    public void removePrescription(Prescription p) {
        p.remove();
    }

    public void addPrescription(Prescription p) {
        p.setEndDate(null);
        p.setEntryType(EntryType.RECIPE);
        p.set("RezeptID", this.getId());
        p.setRecipeOrder(this.getNextOrder());
    }

    private int getNextOrder() {
        List<Prescription> prescriptions = this.getLines();
        if (prescriptions != null && !prescriptions.isEmpty()) {
            return prescriptions.stream().mapToInt(p -> p.getRecipeOrder()).max().orElse(0) + 1;
        }
        return 0;
    }

    @Override
    public boolean delete() {
        Brief brief = this.getBrief();
        if (brief != null) {
            brief.delete();
        }
        return super.delete();
    }

    public Document toXML() {
        List<Prescription> lines = this.getLines();
        Document ret = new Document();
        Element root = new Element("Rezept");
        root.setAttribute(DATE, this.getDate());
        root.setAttribute("Patient", this.getPatient().getLabel());
        root.setAttribute("Aussteller", this.getMandant().getLabel());
        ret.setRootElement(root);
        for (Prescription l : lines) {
            Element item = new Element("Item");
            item.setAttribute("Verordnung", l.getDosis());
            item.setAttribute("Bemerkung", l.getBemerkung());
            item.addContent(l.getLabel());
            root.addContent((Content)item);
        }
        return ret;
    }

    private static class RpZeile {
        public static final String fieldSeparator = "\u00a6";
        String num;
        String name;
        String pck;
        String ds;
        String bem;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.num).append(fieldSeparator).append(this.name).append(fieldSeparator).append(this.pck).append(fieldSeparator).append(this.ds).append(fieldSeparator).append(this.bem);
            return sb.toString();
        }

        public RpZeile() {
        }

        public RpZeile(String in) {
            String[] parts = in.split(fieldSeparator);
            this.num = parts.length > 0 ? parts[0] : "";
            this.name = parts.length > 1 ? parts[1] : "";
            this.pck = parts.length > 2 ? parts[2] : "";
            this.ds = parts.length > 3 ? parts[3] : "";
            this.bem = parts.length > 4 ? parts[4] : "";
        }

        public RpZeile(String num, String name, String pck, String ds, String bem) {
            this.num = num;
            this.name = name;
            this.pck = pck;
            this.ds = ds;
            this.bem = bem;
        }

        public String getBem() {
            return this.bem;
        }

        public void setBem(String bem) {
            this.bem = bem;
        }

        public String getDs() {
            return this.ds;
        }

        public void setDs(String ds) {
            this.ds = ds;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNum() {
            return this.num;
        }

        public void setNum(String num) {
            this.num = num;
        }

        public String getPck() {
            return this.pck;
        }

        public void setPck(String pck) {
            this.pck = pck;
        }
    }
}

