/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.DBConnection;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query<T> {
    private static Logger log = LoggerFactory.getLogger(Query.class);
    public static final String EQUALS = "=";
    public static final String GREATER = ">";
    public static final String LESS = "<";
    public static final String LESS_OR_EQUAL = "<=";
    public static final String GREATER_OR_EQUAL = ">=";
    public static final String NOT_EQUAL = "<>";
    private static final String SELECT_ID_FROM = "SELECT ID FROM ";
    public static final String LIKE = "LIKE";
    private String link = " WHERE ";
    private final boolean clearEntityCache;
    private StringBuilder sql;
    private PersistentObject template;
    private Method load;
    private String lastQuery = "";
    private final LinkedList<IFilter> postQueryFilters = new LinkedList();
    private String ordering;
    private final ArrayList<String> exttables = new ArrayList(2);
    private final String[] ID_FETCH_VAL = new String[]{"ID"};
    private final String[] fetchVals;

    public Query(@NonNull Class<? extends PersistentObject> cl) {
        this(cl, null, null);
    }

    public Query(Class<? extends PersistentObject> cl, @Nullable String field, @Nullable String value) {
        this(cl, field, value, null, null);
    }

    public Query(Class<? extends PersistentObject> cl, @Nullable String field, @Nullable String value, @Nullable String tableName, @Nullable String[] prefetch) {
        this(cl, tableName, field, value, false, prefetch);
    }

    public Query(Class<? extends PersistentObject> cl, String tableName, @Nullable String field, @Nullable String value, boolean clearCache, String[] prefetch) {
        try {
            this.template = CoreHub.poFactory.createTemplate(cl);
            this.load = cl.getMethod("load", String.class);
            this.clearEntityCache = clearCache;
            if (prefetch != null) {
                ArrayList<String> mappedPrefetchValues = new ArrayList<String>(Arrays.asList(this.ID_FETCH_VAL));
                int i = 0;
                while (i < prefetch.length) {
                    String map = PersistentObject.map(tableName, prefetch[i]);
                    if (!map.contains(":")) {
                        mappedPrefetchValues.add(map);
                    } else if (map.startsWith("S:")) {
                        mappedPrefetchValues.add(map.substring(4));
                    } else {
                        throw new UnsupportedOperationException("prefetch value not supported: " + prefetch[i] + " maps to " + map);
                    }
                    ++i;
                }
                this.fetchVals = mappedPrefetchValues.toArray(new String[0]);
            } else {
                this.fetchVals = this.ID_FETCH_VAL;
            }
            this.clear(false);
            if (field != null && value != null) {
                this.add(field, EQUALS, value);
            }
        }
        catch (Exception ex) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Query: Konnte Methode load auf " + cl.getName() + " nicht aufl\u00f6sen", ex, 2);
            throw new PersistenceException((IStatus)status);
        }
    }

    public Query(Class<? extends PersistentObject> cl, String tableName, boolean clearCache, String[] prefetch) {
        this(cl, tableName, null, null, clearCache, prefetch);
    }

    public Query(Class<? extends PersistentObject> cl, String string) {
        try {
            this.template = CoreHub.poFactory.createTemplate(cl);
            this.load = cl.getMethod("load", String.class);
            this.sql = new StringBuilder(500);
            this.sql.append(string);
            this.ordering = null;
            this.fetchVals = ArrayUtils.EMPTY_STRING_ARRAY;
            this.clearEntityCache = false;
        }
        catch (Exception ex) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Query: Konnte Methode load auf " + cl.getName() + " nicht aufl\u00f6sen", ex, 2);
            throw new PersistenceException((IStatus)status);
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean includeDeletedEntriesInQuery) {
        this.sql = new StringBuilder(500);
        String table = this.template.getTableName();
        this.sql.append("SELECT ");
        int i = 0;
        while (i < this.fetchVals.length) {
            this.sql.append(this.fetchVals[i]);
            if (i + 1 < this.fetchVals.length) {
                this.sql.append(", ");
            }
            ++i;
        }
        this.sql.append(" FROM ").append(table);
        String cns = this.template.getConstraint();
        if (cns.equals("")) {
            if (includeDeletedEntriesInQuery) {
                this.link = " WHERE ";
            } else {
                this.sql.append(" WHERE deleted=").append(JdbcLink.wrap((String)"0"));
                this.link = " AND ";
            }
        } else {
            this.sql.append(" WHERE ").append(cns);
            if (!includeDeletedEntriesInQuery) {
                this.sql.append(" AND deleted=").append(JdbcLink.wrap((String)"0"));
            }
            this.link = " AND ";
        }
        this.ordering = null;
        this.exttables.clear();
    }

    private void append(String ... s) {
        this.sql.append(this.link);
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.sql.append(" ").append(a);
            ++n2;
        }
        if (this.link.equals(" WHERE ") || this.link.equals("")) {
            this.link = " AND ";
        }
    }

    public void startGroup() {
        this.append("(");
        this.link = "";
    }

    public void endGroup() {
        this.sql.append(")");
    }

    public void insertTrue() {
        this.append("1=1");
    }

    public void insertFalse() {
        this.append("1=0");
    }

    public void and() {
        if (this.link.equals(" OR ")) {
            this.link = " AND ";
        }
    }

    public void or() {
        this.link = " OR ";
    }

    public boolean add(String feld, String operator, String wert, boolean toLower) {
        String mappedValue;
        String mapped = this.template.map(feld);
        String string = mappedValue = wert == null ? null : PersistentObject.map(this.template.getTableName(), wert, false);
        if (mapped.startsWith("S:D:")) {
            mapped = mapped.substring(4);
            String string2 = wert = wert == null ? "" : wert;
            if (operator.equalsIgnoreCase(LIKE) && !wert.matches("[0-9]{8,8}")) {
                StringBuilder sb = null;
                wert = wert.replaceAll("%", "");
                String filler = "%%%%%%%%";
                if (wert.matches("[0-9]{3,}")) {
                    sb = new StringBuilder(wert);
                    sb.append("%%%%%%%%");
                    wert = sb.substring(0, 8);
                } else {
                    wert = wert.replaceAll("[^0-9]([0-9])\\.", "0$1.");
                    sb = new StringBuilder(wert.replaceAll("\\.", ""));
                    sb.append("%%%%%%%%");
                    wert = String.valueOf(sb.substring(4, 8)) + sb.substring(2, 4) + sb.substring(0, 2);
                }
            } else {
                TimeTool tm = new TimeTool();
                if (tm.set(wert)) {
                    wert = tm.toString(9);
                }
            }
        } else if (mapped.startsWith("EXT:")) {
            int ix = mapped.indexOf(58, 5);
            if (ix == -1) {
                log.error("Ung\u00fcltiges Feld " + feld);
                return false;
            }
            String table = mapped.substring(4, ix);
            mapped = String.valueOf(table) + "." + mapped.substring(ix + 1);
            String firsttable = String.valueOf(this.template.getTableName()) + ".";
            if (!this.exttables.contains(table)) {
                this.exttables.add(table);
                this.sql.insert(SELECT_ID_FROM.length(), String.valueOf(table) + ",");
                ix = this.sql.indexOf("deleted=");
                if (ix != -1) {
                    this.sql.insert(ix, firsttable);
                }
            }
            if (this.exttables.size() == 1) {
                this.sql.insert(7, firsttable);
            }
            this.append(String.valueOf(table) + ".ID=" + firsttable + "ID");
        } else if (mapped.startsWith("S:N:")) {
            mapped = mapped.substring(4);
        } else if (mapped.matches(".*:.*")) {
            log.error("Ung\u00fcltiges Feld " + feld);
            return false;
        }
        if (wert == null) {
            if (operator.equalsIgnoreCase("is") || operator.equals(EQUALS)) {
                operator = "";
            } else if (NOT_EQUAL.equalsIgnoreCase(operator)) {
                operator = "NOT";
            }
            this.append(mapped, "IS", operator, "NULL");
        } else if (mappedValue != null && !mappedValue.equals(wert)) {
            if (mappedValue.startsWith("S:N:")) {
                mappedValue = mappedValue.substring(4);
            }
            this.append(mapped, operator, mappedValue);
        } else {
            wert = PersistentObject.getDefaultConnection().wrapFlavored(wert);
            if (toLower) {
                mapped = "lower(" + mapped + ")";
                wert = "lower(" + wert + ")";
            }
            this.append(mapped, operator, wert);
        }
        return true;
    }

    public boolean add(String feld, String operator, String wert) {
        return this.add(feld, operator, wert, false);
    }

    public void addToken(String token) {
        this.append(token);
    }

    public String findSingle(String f, String op, String v) {
        this.clear();
        this.sql.append(this.link).append(this.template.map(f)).append(op).append(JdbcLink.wrap((String)v));
        String ret = PersistentObject.getConnection().queryString(this.sql.toString());
        return ret;
    }

    public String findOne(String f, String op, String v) {
        this.clear();
        JdbcLink connection = PersistentObject.getConnection();
        this.sql.append(this.link).append(this.template.map(f)).append(op).append(connection.wrapFlavored(v));
        String ret = connection.queryString(this.sql.toString());
        return ret;
    }

    public List<T> queryFields(String[] fields, String[] values, boolean exact) {
        this.clear();
        String op = EQUALS;
        if (!exact) {
            op = " LIKE ";
        }
        this.and();
        int i = 0;
        while (i < fields.length) {
            if (!StringTool.isNothing((Object)values[i])) {
                this.add(fields[i], op, values[i]);
            }
            ++i;
        }
        return this.execute();
    }

    public void orderBy(boolean reverse, String ... n1) {
        if (n1 != null && n1.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(" ORDER BY ");
            String[] stringArray = n1;
            int n = n1.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String mapped = this.template.map(s);
                if (mapped.matches("[A-Z]{2,}:.+")) {
                    log.error("Ung\u00fcltiges Feld " + s);
                    return;
                }
                if (mapped.startsWith("S:D:") || mapped.startsWith("S:N:")) {
                    mapped = mapped.substring(4);
                }
                sb.append(mapped);
                if (reverse) {
                    sb.append(" DESC");
                }
                sb.append(",");
                ++n2;
            }
            sb.delete(sb.length() - 1, 10000);
            this.ordering = sb.toString();
        }
    }

    public List<T> execute() {
        return this.execute(PersistentObject.getDefaultConnection());
    }

    public List<T> execute(DBConnection connection) {
        LinkedList ret = new LinkedList();
        return (List)this.execute(ret, connection);
    }

    public Collection<T> execute(Collection<T> collection) {
        return this.execute(collection, PersistentObject.getDefaultConnection());
    }

    public Collection<T> execute(Collection<T> collection, DBConnection connection) {
        if (this.ordering != null) {
            this.sql.append(this.ordering);
        }
        this.lastQuery = this.sql.toString();
        return this.queryExpression(this.lastQuery, collection, connection);
    }

    public ArrayList<String> execute(PreparedStatement ps, String[] values) {
        try {
            int i = 0;
            while (i < values.length) {
                ps.setString(i + 1, values[i]);
                ++i;
            }
            if (ps.execute()) {
                ArrayList<String> ret = new ArrayList<String>();
                ResultSet res = ps.getResultSet();
                while (res.next()) {
                    ret.add(res.getString(1));
                }
                return ret;
            }
        }
        catch (Exception ex) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler beim Ausf\u00fchren von " + this.sql.toString(), ex, 2);
            throw new PersistenceException((IStatus)status);
        }
        return null;
    }

    public Collection<T> queryExpression(String expr, Collection<T> ret) {
        return this.queryExpression(expr, ret, PersistentObject.getDefaultConnection());
    }

    public Collection<T> queryExpression(String expr, Collection<T> ret, DBConnection connection) {
        if (ret == null) {
            ret = new LinkedList<T>();
        }
        boolean setConnection = connection != PersistentObject.getDefaultConnection();
        JdbcLink.Stm stm = connection.getStatement();
        try {
            Collection<T> collection;
            block22: {
                Throwable throwable = null;
                Object var7_9 = null;
                ResultSet res = stm.query(expr);
                try {
                    log.debug("Executed " + expr);
                    while (res != null && res.next()) {
                        String id = res.getString(1);
                        Object o = this.load.invoke(null, id);
                        if (o == null) continue;
                        if (setConnection) {
                            ((PersistentObject)o).setDBConnection(connection);
                        }
                        PersistentObject po = (PersistentObject)o;
                        if (this.clearEntityCache) {
                            po.clearCachedAttributes();
                        }
                        if (this.fetchVals.length > 1) {
                            int i = 1;
                            while (i < this.fetchVals.length) {
                                Object prefetchVal = res.getObject(i + 1);
                                po.putInCache(this.fetchVals[i], prefetchVal);
                                ++i;
                            }
                        }
                        boolean bAdd = true;
                        for (IFilter fi : this.postQueryFilters) {
                            if (fi.select(o)) continue;
                            bAdd = false;
                            break;
                        }
                        if (!bAdd) continue;
                        ret.add(o);
                    }
                    collection = ret;
                    if (res == null) break block22;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (res != null) {
                                res.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler bei Datenbankabfrage " + ex.getMessage(), ex, 2);
                        log.warn("Fehler [{}] bei Datenbankabfrage:\n[{};]", (Object)ex.getMessage(), (Object)expr);
                        throw new PersistenceException((IStatus)status);
                    }
                }
                res.close();
            }
            return collection;
        }
        finally {
            connection.releaseStatement(stm);
        }
    }

    public int size() {
        try {
            JdbcLink.Stm stm = PersistentObject.getConnection().getStatement();
            String res = stm.queryString("SELECT COUNT(*) FROM " + this.template.getTableName());
            PersistentObject.getConnection().releaseStatement(stm);
            return Integer.parseInt(res);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return 10000;
        }
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public String getActualQuery() {
        return this.sql.toString();
    }

    public void addPostQueryFilter(IFilter f) {
        this.postQueryFilters.add(f);
    }

    public void removePostQueryFilter(IFilter f) {
        this.postQueryFilters.remove(f);
    }
}

