/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import java.io.File;

public class FileUtility {
    public static String DIRECTORY_SEPARATOR = File.separator;
    public static final String ZIP_EXTENSION = ".gz";

    private static String getCorrectSeparators(String pathOrFilename) {
        return pathOrFilename.replace("\\", DIRECTORY_SEPARATOR).replace("//", DIRECTORY_SEPARATOR).replace("/", DIRECTORY_SEPARATOR);
    }

    private static String removeMultipleSeparators(String pathOrFilename) {
        String doubleSeparator = String.valueOf(DIRECTORY_SEPARATOR) + DIRECTORY_SEPARATOR;
        if (pathOrFilename.indexOf(doubleSeparator) >= 0) {
            pathOrFilename = pathOrFilename.replace(doubleSeparator, DIRECTORY_SEPARATOR);
        }
        return pathOrFilename;
    }

    public static String getCorrectPath(String path) throws IllegalArgumentException {
        if (path == null) {
            return "";
        }
        path = FileUtility.getCorrectSeparators(path);
        if (!(path = FileUtility.removeMultipleSeparators(path)).endsWith(DIRECTORY_SEPARATOR)) {
            path = String.valueOf(path) + DIRECTORY_SEPARATOR;
        }
        return path;
    }

    public static boolean doesFileExist(String filePathName) {
        File file = new File(filePathName);
        return file.isFile() && file.exists();
    }

    public static boolean isRootDir(String dir) {
        return dir.startsWith(DIRECTORY_SEPARATOR) || dir.indexOf(":") > 0;
    }

    public static void deleteFile(String filePathName) throws IllegalArgumentException {
        if (FileUtility.doesFileExist(filePathName)) {
            File file = new File(filePathName);
            file.delete();
        }
    }

    public static String getFilepath(String filenamePath) {
        String correctFilenamePath = FileUtility.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return "";
        }
        return correctFilenamePath.substring(0, correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR));
    }

    public static String getFilename(String filenamePath) {
        String correctFilenamePath = FileUtility.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return filenamePath;
        }
        return correctFilenamePath.substring(correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR) + 1, correctFilenamePath.length());
    }

    public static String getNakedFilename(String filenamePath) {
        String filename = FileUtility.getFilename(filenamePath);
        if (filename.lastIndexOf(".") > 0) {
            return filename.substring(0, filename.lastIndexOf("."));
        }
        return filename;
    }

    public static String getFileExtension(String filenamePath) {
        String filename = FileUtility.getFilename(filenamePath);
        if (filename.lastIndexOf(".") > 0) {
            return filename.substring(filename.lastIndexOf("."), filename.length());
        }
        return "";
    }
}

