/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.events;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisContext {
    private LinkedHashMap<Class<?>, IPersistentObject> currentSelection;
    private LinkedHashMap<Class<?>, IPersistentObject> newSelection;
    private Logger log = LoggerFactory.getLogger(ElexisContext.class);

    public ElexisContext() {
        this.currentSelection = new LinkedHashMap();
        this.newSelection = new LinkedHashMap();
    }

    public synchronized List<ElexisEvent> setSelection(Class<?> typeClass, IPersistentObject object) {
        this.newSelection = (LinkedHashMap)this.currentSelection.clone();
        if (typeClass.equals(Patient.class)) {
            this.setPatientSelection((Patient)object);
        } else if (typeClass.equals(Konsultation.class)) {
            this.setKonsultationSelection((Konsultation)object);
        } else if (typeClass.equals(Fall.class)) {
            this.setFallSelection((Fall)object);
        } else {
            this.newSelection.put(typeClass, object);
        }
        return this.determineChangeEvents();
    }

    private List<ElexisEvent> determineChangeEvents() {
        ArrayList<ElexisEvent> events = new ArrayList<ElexisEvent>();
        Set<Class<?>> keySet = this.newSelection.keySet();
        for (Class<?> clazz : keySet) {
            IPersistentObject obj1 = this.newSelection.get(clazz);
            IPersistentObject obj2 = this.currentSelection.get(clazz);
            if (obj1 == null) {
                if (obj1 == obj2) continue;
                events.add(new ElexisEvent((PersistentObject)obj1, clazz, 32));
                this.log.info("[DESEL] " + clazz + " || " + this.toString(obj2) + " --> " + this.toString(obj1));
                continue;
            }
            if (obj1.equals(obj2)) continue;
            events.add(new ElexisEvent((PersistentObject)obj1, clazz, 16));
            this.log.info("[SEL] " + clazz + "  || " + this.toString(obj2) + " --> " + this.toString(obj1));
        }
        this.currentSelection = (LinkedHashMap)this.newSelection.clone();
        return events;
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof PersistentObject) {
            PersistentObject po = (PersistentObject)obj;
            return po.getId();
        }
        return obj.toString();
    }

    private void setFallSelection(Fall f) {
        if (f == null) {
            this.newSelection.put(Fall.class, null);
            this.newSelection.put(Konsultation.class, null);
            return;
        }
        if (f.equals(this.currentSelection.get(Fall.class))) {
            return;
        }
        this.newSelection.put(Fall.class, f);
        this.newSelection.put(Konsultation.class, f.getLetzteBehandlung());
    }

    private void setKonsultationSelection(Konsultation k) {
        if (k == null) {
            this.newSelection.put(Konsultation.class, null);
            return;
        }
        if (k.equals(this.currentSelection.get(Konsultation.class))) {
            return;
        }
        this.newSelection.put(Konsultation.class, k);
        this.newSelection.put(Fall.class, k.getFall());
    }

    private void setPatientSelection(Patient p) {
        if (p == null) {
            this.newSelection.put(Patient.class, null);
            this.newSelection.put(Fall.class, null);
            this.newSelection.put(Konsultation.class, null);
            return;
        }
        if (p.equals(this.currentSelection.get(Patient.class))) {
            return;
        }
        Konsultation k = p.getLetzteKons(false);
        Fall f = k != null ? k.getFall() : null;
        this.newSelection.put(Patient.class, p);
        this.newSelection.put(Fall.class, f);
        this.newSelection.put(Konsultation.class, k);
    }

    public IPersistentObject getSelected(Class<?> template) {
        return this.currentSelection.get(template);
    }
}

