/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.admin;

import ch.elexis.admin.ACE;
import ch.elexis.admin.AbstractAccessControl;
import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.admin.IACLContributor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLContributor
implements IACLContributor {
    private static Logger log = LoggerFactory.getLogger(ACLContributor.class);

    @Override
    public ACE[] getACL() {
        try {
            return this.findAllRightsThroughReflection();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("Error reflecting access rights", (Throwable)e);
            return null;
        }
    }

    private ACE[] findAllRightsThroughReflection() throws IllegalArgumentException, IllegalAccessException {
        Field[] declaredFields;
        ArrayList<ACE> list = new ArrayList<ACE>();
        Field[] fieldArray = declaredFields = AccessControlDefaults.class.getFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType().equals(ACE.class)) {
                list.add((ACE)field.get(null));
            }
            ++n2;
        }
        return list.toArray(new ACE[list.size()]);
    }

    @Override
    public void initializeDefaults(AbstractAccessControl ac) {
        AccessControlDefaults.initializeDefaults(ac);
    }
}

