/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.ui.dbcheck.contributions.ReChargeTarmedOpenCons;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class ReChargeLabOpenCons
extends ExternalMaintenance {
    private ICodeElementService codeElementService;
    private ServiceReference<ICodeElementService> codeServiceRef;
    private IBillingService billingService;
    private ServiceReference<IBillingService> billingServiceRef;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringJoiner sj = new StringJoiner("\n");
        if (this.initCodeElementService() && this.initBillingService()) {
            Query queryPatients = new Query(Patient.class);
            List patients = queryPatients.execute();
            pm.beginTask("Laborwerte nach verrechnen", patients.size());
            for (Patient patient : patients) {
                Map<LocalDate, Konsultation> openKonsultationMap = this.getOpenKonsultationMap(patient);
                if (!openKonsultationMap.isEmpty()) {
                    Query queryLabResults = new Query(LabResult.class);
                    queryLabResults.add("PatientID", "=", patient.getId());
                    List labResults = queryLabResults.execute();
                    for (LabResult labResult : labResults) {
                        String ealCode;
                        LabMapping mapping;
                        if (labResult.getOrigin() == null || labResult.getItem() == null || (mapping = LabMapping.getByContactAndItemId((String)labResult.getOrigin().getId(), (String)labResult.getItem().getId())) == null || !mapping.isCharge() || (ealCode = ((LabItem)labResult.getItem()).getBillingCode()) == null || ealCode.isEmpty()) continue;
                        LocalDate labResultLocalDate = this.getLocalDate(labResult);
                        Konsultation openKons = openKonsultationMap.get(labResultLocalDate);
                        if (openKons != null) {
                            IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)openKons, IEncounter.class).get();
                            Optional matchingVerrechenbar = this.codeElementService.loadFromString("EAL 2009", ealCode, this.getContext(encounter));
                            if (!matchingVerrechenbar.isPresent() || this.isAlreadyBilled(encounter, (ICodeElement)matchingVerrechenbar.get())) continue;
                            this.billingService.bill((IBillable)matchingVerrechenbar.get(), encounter, 1.0);
                            continue;
                        }
                        sj.add("No open cons to bill [" + ealCode + "] on date [" + labResultLocalDate + "] of pat [" + patient.getPatCode() + "]");
                    }
                }
                pm.worked(1);
            }
            pm.done();
            this.deInitCodeElementService();
            this.deInitBillingService();
        }
        return sj.toString();
    }

    private LocalDate getLocalDate(LabResult labResult) {
        if (labResult.getObservationTime() != null) {
            return labResult.getObservationTime().toLocalDate();
        }
        if (labResult.getDateTime() != null) {
            return labResult.getDateTime().toLocalDate();
        }
        LoggerFactory.getLogger(this.getClass()).warn("No local date for lab result [" + labResult.getId() + "]");
        return LocalDate.MIN;
    }

    private boolean isAlreadyBilled(IEncounter encounter, ICodeElement iCodeElement) {
        for (IBilled verrechnet : encounter.getBilled()) {
            IBillable verrechenbar = verrechnet.getBillable();
            if (!verrechenbar.getCodeSystemName().equals(iCodeElement.getCodeSystemName()) || !verrechenbar.getCode().equals(iCodeElement.getCode())) continue;
            return true;
        }
        return false;
    }

    private Map<LocalDate, Konsultation> getOpenKonsultationMap(Patient patient) {
        HashMap<LocalDate, Konsultation> ret = new HashMap<LocalDate, Konsultation>();
        Fall[] fallArray = patient.getFaelle();
        int n = fallArray.length;
        int n2 = 0;
        while (n2 < n) {
            Fall fall = fallArray[n2];
            if (fall.isOpen()) {
                Konsultation[] konsultationArray = fall.getBehandlungen(false);
                int n3 = konsultationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Konsultation konsultation = konsultationArray[n4];
                    if (konsultation.isBillable()) {
                        ret.put(konsultation.getDateTime().toLocalDate(), konsultation);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return ret;
    }

    private HashMap<Object, Object> getContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (encounter != null) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
            ICoverage coverage = encounter.getCoverage();
            if (coverage != null) {
                ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
            }
        }
        return ret;
    }

    private void deInitCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        if (this.codeServiceRef != null) {
            context.ungetService(this.codeServiceRef);
            this.codeElementService = null;
        }
    }

    private boolean initCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        this.codeServiceRef = context.getServiceReference(ICodeElementService.class);
        if (this.codeServiceRef != null) {
            this.codeElementService = (ICodeElementService)context.getService(this.codeServiceRef);
            return true;
        }
        return false;
    }

    private void deInitBillingService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        if (this.billingServiceRef != null) {
            context.ungetService(this.billingServiceRef);
            this.billingService = null;
        }
    }

    private boolean initBillingService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        this.billingServiceRef = context.getServiceReference(IBillingService.class);
        if (this.billingServiceRef != null) {
            this.billingService = (IBillingService)context.getService(this.billingServiceRef);
            return true;
        }
        return false;
    }

    @Override
    public String getMaintenanceDescription() {
        return "Laborwerte aller offenen Konsutlationen neu verrechnen.";
    }
}

