/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePicker;
import java.util.HashMap;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Patientenzaehler
extends TitleAreaDialog {
    DatePicker dpVon;
    DatePicker dpBis;
    public int kons;
    public int cases;
    public int men;
    public int women;

    public String getResult() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mandant ").append(CoreHub.actMandant.getLabel()).append(":\n").append("Total ").append(this.men + this.women).append(" Patienten; ").append(this.women).append(" Frauen und ").append(this.men).append(" M\u00e4nner.\n").append("in ").append(this.kons).append(" Konsultationen zu ").append(this.cases).append(" F\u00e4llen.");
        return sb.toString();
    }

    public Patientenzaehler() {
        super(UiDesk.getTopShell());
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(ret, 0);
        inner.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        inner.setLayout((Layout)new GridLayout(2, true));
        new Label(inner, 0).setText("Startdatum");
        new Label(inner, 0).setText("Enddatum");
        this.dpVon = new DatePicker(inner, 0);
        this.dpBis = new DatePicker(inner, 0);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle("Patientenz\u00e4hler");
        this.setMessage("Bitte start- und enddatum (inklusive) angeben");
    }

    protected void okPressed() {
        TimeTool ttVon = new TimeTool(this.dpVon.getDate().getTime());
        TimeTool ttBis = new TimeTool(this.dpBis.getDate().getTime());
        Query qbe = new Query(Konsultation.class);
        qbe.add("Datum", ">=", ttVon.toString(9));
        qbe.add("Datum", "<=", ttBis.toString(9));
        qbe.add("MandantID", "=", CoreHub.actMandant.getId());
        HashMap<String, Patient> maenner = new HashMap<String, Patient>();
        HashMap<String, Patient> frauen = new HashMap<String, Patient>();
        HashMap<String, Fall> faelle = new HashMap<String, Fall>();
        for (Konsultation k : qbe.execute()) {
            Fall fall = k.getFall();
            faelle.put(fall.getId(), fall);
            Patient p = fall.getPatient();
            if (p.getGeschlecht().equals("m")) {
                maenner.put(p.getId(), p);
            } else {
                frauen.put(p.getId(), p);
            }
            ++this.kons;
        }
        this.men = maenner.size();
        this.women = frauen.size();
        this.cases = faelle.size();
        super.okPressed();
    }
}

