/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem.provider;

import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class TextTemplateViewerComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int direction = 1;
    private int propertyIndex = 0;

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        TextTemplate template1 = (TextTemplate)e1;
        TextTemplate template2 = (TextTemplate)e2;
        int rc = 0;
        switch (this.propertyIndex) {
            case 1: {
                rc = template1.getName().compareTo(template2.getName());
                break;
            }
            case 2: {
                rc = template1.getMimeTypePrintname().compareTo(template2.getMimeTypePrintname());
                break;
            }
            case 3: {
                rc = template1.getMandantLabel().compareTo(template2.getMandantLabel());
                break;
            }
            case 4: {
                if (template1.askForAddress() == template2.askForAddress()) break;
                rc = template1.askForAddress() ? 1 : -1;
                break;
            }
            case 5: {
                String printertray1 = String.valueOf(StringUtils.defaultString((String)template1.getPrinter())) + "/" + StringUtils.defaultString((String)template1.getTray());
                String printertray2 = String.valueOf(StringUtils.defaultString((String)template2.getPrinter())) + "/" + StringUtils.defaultString((String)template2.getTray());
                rc = printertray1.compareTo(printertray2);
                break;
            }
            case 6: {
                if (template1.getDescription().isEmpty() && template2.getDescription().isEmpty()) break;
                rc = template1.getDescription().compareToIgnoreCase(template2.getDescription());
                break;
            }
            default: {
                rc = 0;
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }
}

