/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.AssignStickerDialog;
import ch.elexis.core.ui.util.CoreUiUtil;
import java.util.List;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class StickerComposite
extends Composite {
    private FormToolkit toolkit;
    private IPatient actPatient;

    public StickerComposite(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.setLayoutData(new TableWrapData(256, 16, 1, 1));
        ColumnLayout cwl = new ColumnLayout();
        cwl.maxNumColumns = 4;
        cwl.horizontalSpacing = 1;
        cwl.bottomMargin = 10;
        cwl.topMargin = 0;
        cwl.rightMargin = 1;
        cwl.leftMargin = 1;
        this.setLayout((Layout)cwl);
        this.setBackground(parent.getBackground());
        this.toolkit = toolkit;
        this.setVisible(false);
    }

    public static StickerComposite createWrappedStickerComposite(Composite parent, FormToolkit tk) {
        Composite wrapper = new Composite(parent, 0);
        TableWrapLayout wlayout = new TableWrapLayout();
        wlayout.bottomMargin = 0;
        wlayout.topMargin = 0;
        wrapper.setLayoutData((Object)new GridData(768));
        wrapper.setLayout((Layout)wlayout);
        wrapper.setBackground(UiDesk.getColor("weiss"));
        StickerComposite stickerComposite = new StickerComposite(wrapper, 0, tk);
        stickerComposite.setBackground(UiDesk.getColor("weiss"));
        return stickerComposite;
    }

    public void setPatient(IPatient p) {
        this.actPatient = p;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control cc = controlArray[n2];
            cc.dispose();
            ++n2;
        }
        this.setVisible(false);
        List etis = StickerServiceHolder.get().getStickers((Identifiable)this.actPatient);
        if (etis == null) {
            return;
        }
        if (etis.size() > 0) {
            this.setVisible(true);
            for (ISticker et : etis) {
                if (et == null) continue;
                Composite stickerForm = CoreUiUtil.createForm(this, et);
                if (this.toolkit != null) {
                    this.toolkit.adapt(stickerForm);
                    stickerForm.setBackground(CoreUiUtil.getColorForString(et.getBackground()));
                }
                Menu menu = new Menu((Control)stickerForm);
                stickerForm.setMenu(menu);
                stickerForm.setLayoutData((Object)new ColumnLayoutData());
                final MenuItem miAdd = this.createMenuItemAdd(menu);
                final MenuItem miRemove = new MenuItem(menu, 0);
                miRemove.setData("sticker", (Object)et);
                miRemove.setText("Sticker entfernen");
                miRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem mi = (MenuItem)e.getSource();
                        ISticker et = (ISticker)mi.getData("sticker");
                        StickerServiceHolder.get().removeSticker(et, (Identifiable)StickerComposite.this.actPatient);
                        StickerComposite.this.setPatient(StickerComposite.this.actPatient);
                        StickerComposite.this.getParent().getParent().layout(true);
                    }
                });
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuShown(MenuEvent e) {
                        miRemove.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONTAKT_ETIKETTE));
                        miAdd.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONTAKT_ETIKETTE));
                    }
                });
            }
        } else {
            this.setVisible(true);
            Menu menu = new Menu((Control)this);
            this.setMenu(menu);
            this.createMenuItemAdd(menu);
        }
        this.layout();
    }

    private MenuItem createMenuItemAdd(Menu menu) {
        MenuItem miAdd = new MenuItem(menu, 0);
        miAdd.setText("Sticker hinzuf\u00fcgen");
        miAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignStickerDialog assignStickerDialog = new AssignStickerDialog(StickerComposite.this.getShell(), (Identifiable)StickerComposite.this.actPatient);
                if (assignStickerDialog.open() == 0) {
                    StickerComposite.this.setPatient(StickerComposite.this.actPatient);
                    StickerComposite.this.getParent().getParent().layout(true);
                }
            }
        });
        miAdd.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONTAKT_ETIKETTE));
        return miAdd;
    }
}

