/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class SelectFallDialog
extends TitleAreaDialog {
    Fall[] faelle;
    public Fall result;
    List list;
    private UpdateFallListListener updateFallListener = new UpdateFallListListener(Fall.class, 255);

    public SelectFallDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        GridLayout gl_ret = new GridLayout(1, false);
        gl_ret.marginWidth = 0;
        gl_ret.marginHeight = 0;
        ret.setLayout((Layout)gl_ret);
        this.list = new List(ret, 2048);
        this.list.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.reloadFaelleList();
        ToolBarManager tbManager = new ToolBarManager(8388928);
        tbManager.add(GlobalActions.neuerFallAction);
        tbManager.createControl(ret);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.updateFallListener});
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SelectFallDialog_selectFall);
        this.setMessage(Messages.SelectFallDialog_pleaseSelectCase);
        this.getShell().setText(Messages.SelectFallDialog_Cases);
    }

    public void okPressed() {
        int sel = this.list.getSelectionIndex();
        this.result = sel == -1 ? null : this.faelle[sel];
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.updateFallListener});
        super.okPressed();
    }

    protected void cancelPressed() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.updateFallListener});
        super.cancelPressed();
    }

    private void reloadFaelleList() {
        this.list.removeAll();
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        Fall[] fallArray = this.faelle = sp != null ? sp.getFaelle() : new Fall[]{};
        int n = this.faelle.length;
        int n2 = 0;
        while (n2 < n) {
            Fall f = fallArray[n2];
            this.list.add(f.getLabel());
            ++n2;
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private class UpdateFallListListener
    extends ElexisUiEventListenerImpl {
        UpdateFallListListener(Class<?> clazz, int mode) {
            super(clazz, mode);
        }

        @Override
        public void runInUi(ElexisEvent ev) {
            SelectFallDialog.this.reloadFaelleList();
        }
    }
}

